/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.exception;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import org.jboss.logging.Logger;
import org.jboss.seam.faces.exception.CatchExceptionHandler;
import org.jboss.seam.solder.beanManager.BeanManagerLocator;
import org.jboss.seam.solder.beanManager.BeanManagerUnavailableException;

public class CatchExceptionHandlerFactory
extends ExceptionHandlerFactory {
    private final transient Logger log = Logger.getLogger(CatchExceptionHandlerFactory.class);
    private ExceptionHandlerFactory parent;
    private transient boolean catchUnavailable = false;
    private transient BeanManagerLocator locator;

    public CatchExceptionHandlerFactory(ExceptionHandlerFactory parent) {
        this.parent = parent;
    }

    public ExceptionHandler getExceptionHandler() {
        this.log.trace((Object)"Creating the JSF exception handler");
        if (this.catchUnavailable) {
            this.log.trace((Object)"Catch integration previously disabled");
            return this.parent.getExceptionHandler();
        }
        BeanManager beanManager = null;
        try {
            this.locator = new BeanManagerLocator();
            beanManager = this.locator.getBeanManager();
        }
        catch (BeanManagerUnavailableException e) {
            this.log.info((Object)"Could not location BeanManager, Catch integration disabled");
            this.catchUnavailable = true;
            return this.parent.getExceptionHandler();
        }
        if (beanManager.getBeans(CatchExceptionHandler.class, new Annotation[0]).isEmpty()) {
            this.log.info((Object)"Catch not available, Catch integration disabled");
            this.catchUnavailable = true;
            return this.parent.getExceptionHandler();
        }
        this.log.info((Object)"Catch integration enabled");
        return new CatchExceptionHandler(this.parent.getExceptionHandler(), beanManager);
    }
}

