/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.viewdata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.jboss.seam.faces.viewdata.ViewDataConfigurationExtension;
import org.jboss.seam.faces.viewdata.ViewDataStore;

@ApplicationScoped
public class ViewDataStoreImpl
implements ViewDataStore {
    private final ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, List<? extends Annotation>>> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, Annotation>> data = new ConcurrentHashMap();

    @Inject
    public void setup(ViewDataConfigurationExtension extension) {
        for (Map.Entry<String, Set<Annotation>> e : extension.getData().entrySet()) {
            for (Annotation i : e.getValue()) {
                this.addData(e.getKey(), i);
            }
        }
    }

    public synchronized void addData(String viewId, Annotation annotation) {
        ConcurrentHashMap<String, Annotation> map = this.data.get(annotation.annotationType());
        if (map == null) {
            map = new ConcurrentHashMap();
            this.data.put(annotation.annotationType(), map);
        }
        map.put(viewId, annotation);
    }

    public <T extends Annotation> T getData(String viewId, Class<T> type) {
        List<T> data = this.prepareCache(viewId, type);
        if (data != null && data.size() > 0) {
            return (T)((Annotation)data.get(0));
        }
        return null;
    }

    public <T extends Annotation> T getDataForCurrentViewId(Class<T> type) {
        UIViewRoot viewRoot;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && (viewRoot = context.getViewRoot()) != null) {
            return this.getData(viewRoot.getViewId(), type);
        }
        return null;
    }

    public <T extends Annotation> List<T> getAllData(String viewId, Class<T> type) {
        List<T> data = this.prepareCache(viewId, type);
        if (data != null) {
            return Collections.unmodifiableList(data);
        }
        return null;
    }

    public <T extends Annotation> List<T> getAllDataForCurrentViewId(Class<T> type) {
        return this.getAllData(FacesContext.getCurrentInstance().getViewRoot().getViewId(), type);
    }

    private <T extends Annotation> List<T> prepareCache(String viewId, Class<T> type) {
        ArrayList annotationData;
        ConcurrentHashMap newMap;
        ConcurrentHashMap<String, List<Annotation>> map = this.cache.get(type);
        if (map == null && (map = this.cache.putIfAbsent(type, newMap = new ConcurrentHashMap())) == null) {
            map = newMap;
        }
        if ((annotationData = map.get(viewId)) == null) {
            ArrayList newList = new ArrayList();
            Map viewData = this.data.get(type);
            ArrayList resultingViews = new ArrayList();
            if (viewData != null) {
                for (Map.Entry e : viewData.entrySet()) {
                    if (((String)e.getKey()).endsWith("*")) {
                        String cutView = ((String)e.getKey()).substring(0, ((String)e.getKey()).length() - 1);
                        if (!viewId.startsWith(cutView)) continue;
                        resultingViews.add(e.getKey());
                        continue;
                    }
                    if (!((String)e.getKey()).equals(viewId)) continue;
                    resultingViews.add(e.getKey());
                }
                Collections.sort(resultingViews, StringLengthComparator.INSTANCE);
                for (String i : resultingViews) {
                    newList.add(viewData.get(i));
                }
            }
            if ((annotationData = (ArrayList)map.putIfAbsent(viewId, newList)) == null) {
                annotationData = newList;
            }
        }
        return annotationData;
    }

    private static class StringLengthComparator
    implements Comparator<String> {
        public static final StringLengthComparator INSTANCE = new StringLengthComparator();

        private StringLengthComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return 0;
        }
    }
}

