/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.event;

import java.util.List;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.jboss.logging.Logger;
import org.jboss.seam.faces.event.AbstractListener;
import org.jboss.seam.faces.event.SystemEventBridge;

public class DelegatingSystemEventListener
extends AbstractListener<SystemEventListener>
implements SystemEventListener {
    private static final Logger log = Logger.getLogger(DelegatingSystemEventListener.class);

    public boolean isListenerForSource(Object source) {
        return true;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PreDestroyApplicationEvent && !this.isBeanManagerAvailable()) {
            log.info((Object)("BeanManager no longer available; Cannot notify CDI-managed listeners of " + PreDestroyApplicationEvent.class.getSimpleName()));
            return;
        }
        for (SystemEventListener l : this.getEventListeners()) {
            if (!l.isListenerForSource(event.getSource())) continue;
            l.processEvent(event);
        }
    }

    private List<SystemEventListener> getEventListeners() {
        return this.getListeners(SystemEventBridge.class);
    }
}

