/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.view.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.faces.event.PhaseIdType;
import org.jboss.seam.faces.event.PreNavigateEvent;
import org.jboss.seam.faces.event.qualifier.After;
import org.jboss.seam.faces.event.qualifier.Before;
import org.jboss.seam.faces.event.qualifier.InvokeApplication;
import org.jboss.seam.faces.event.qualifier.RenderResponse;
import org.jboss.seam.faces.event.qualifier.RestoreView;
import org.jboss.seam.faces.view.config.AccessDeniedView;
import org.jboss.seam.faces.view.config.LoginView;
import org.jboss.seam.faces.view.config.RestrictAtPhase;
import org.jboss.seam.faces.view.config.RestrictAtPhaseDefault;
import org.jboss.seam.faces.view.config.ViewConfigStore;
import org.jboss.seam.security.annotations.SecurityBindingType;
import org.jboss.seam.security.events.AuthorizationCheckEvent;
import org.jboss.seam.solder.core.Requires;

@Requires(value={"org.jboss.seam.security.extension.SecurityExtension"})
public class SecurityPhaseListener {
    private final transient Logger log = Logger.getLogger(SecurityPhaseListener.class);
    private static final String PRE_LOGIN_VIEW = SecurityPhaseListener.class.getName() + "_PRE_LOGIN_VIEW";
    @Inject
    private ViewConfigStore viewConfigStore;
    @Inject
    private Event<AuthorizationCheckEvent> authorizationCheckEvent;

    public void observeRenderResponse(@Observes @Before @RenderResponse PhaseEvent event) {
        this.log.debug((Object)"Before Render Response event");
        this.performObservation(event, PhaseIdType.RENDER_RESPONSE);
    }

    public void observeInvokeApplication(@Observes @Before @InvokeApplication PhaseEvent event) {
        this.log.debug((Object)"Before Render Response event");
        this.performObservation(event, PhaseIdType.INVOKE_APPLICATION);
    }

    public void observeRestoreView(@Observes @After @RestoreView PhaseEvent event) {
        this.log.debug((Object)"After Restore View event");
        this.performObservation(event, PhaseIdType.RESTORE_VIEW);
    }

    private void performObservation(PhaseEvent event, PhaseIdType phaseIdType) {
        UIViewRoot viewRoot = event.getFacesContext().getViewRoot();
        List<? extends Annotation> restrictionsForPhase = this.getRestrictionsForPhase(phaseIdType, viewRoot.getViewId());
        if (restrictionsForPhase != null) {
            this.log.debugf("Enforcing on phase %s", (Object)phaseIdType);
            this.enforce(event.getFacesContext(), viewRoot, restrictionsForPhase);
        }
    }

    public List<? extends Annotation> getRestrictionsForPhase(PhaseIdType currentPhase, String viewId) {
        List allSecurityAnnotations = this.viewConfigStore.getAllQualifierData(viewId, SecurityBindingType.class);
        ArrayList<Annotation> applicableSecurityAnnotations = null;
        for (Annotation annotation : allSecurityAnnotations) {
            PhaseIdType[] defaultPhases;
            if (!this.isAnnotationApplicableToPhase(annotation, currentPhase, defaultPhases = this.getDefaultPhases(viewId))) continue;
            if (applicableSecurityAnnotations == null) {
                applicableSecurityAnnotations = new ArrayList<Annotation>();
            }
            applicableSecurityAnnotations.add(annotation);
        }
        return applicableSecurityAnnotations;
    }

    public boolean isAnnotationApplicableToPhase(Annotation annotation, PhaseIdType currentPhase, PhaseIdType[] defaultPhases) {
        Method restrictAtViewMethod = this.getRestrictAtViewMethod(annotation);
        Object[] phasedIds = null;
        if (restrictAtViewMethod != null) {
            phasedIds = this.getRestrictedPhaseIds(restrictAtViewMethod, annotation);
        }
        if (phasedIds == null) {
            this.log.debug((Object)"Falling back on default phase ids");
            phasedIds = defaultPhases;
        }
        return Arrays.binarySearch(phasedIds, currentPhase) >= 0;
    }

    public PhaseIdType[] getDefaultPhases(String viewId) {
        PhaseIdType[] defaultPhases = null;
        RestrictAtPhase restrictAtPhase = (RestrictAtPhase)this.viewConfigStore.getAnnotationData(viewId, RestrictAtPhase.class);
        if (restrictAtPhase != null) {
            defaultPhases = restrictAtPhase.value();
        }
        if (defaultPhases == null) {
            defaultPhases = RestrictAtPhaseDefault.DEFAULT_PHASES;
        }
        return defaultPhases;
    }

    public Method getRestrictAtViewMethod(Annotation annotation) {
        Method restrictAtViewMethod;
        try {
            restrictAtViewMethod = annotation.annotationType().getDeclaredMethod("restrictAtPhase", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            restrictAtViewMethod = null;
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException("restrictAtView method must be accessible", ex);
        }
        return restrictAtViewMethod;
    }

    public PhaseIdType[] getRestrictedPhaseIds(Method restrictAtViewMethod, Annotation annotation) {
        PhaseIdType[] phaseIds;
        try {
            phaseIds = (PhaseIdType[])restrictAtViewMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("restrictAtView method must be accessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return phaseIds;
    }

    private void enforce(FacesContext context, UIViewRoot viewRoot, List<? extends Annotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            this.log.debug((Object)"Annotations is null/empty");
            return;
        }
        AuthorizationCheckEvent event = new AuthorizationCheckEvent(annotations);
        this.authorizationCheckEvent.fire((Object)event);
        if (!event.isPassed()) {
            if (context.getExternalContext().getUserPrincipal() == null) {
                this.log.debug((Object)"Access denied - not logged in");
                this.redirectToLoginPage(context, viewRoot);
                return;
            }
            this.log.debug((Object)"Access denied - not authorized");
            this.redirectToAccessDeniedView(context, viewRoot);
            return;
        }
        this.log.debug((Object)"Access granted");
    }

    private void redirectToLoginPage(FacesContext context, UIViewRoot viewRoot) {
        context.getExternalContext().getSessionMap().put(PRE_LOGIN_VIEW, viewRoot.getViewId());
        LoginView loginView = (LoginView)this.viewConfigStore.getAnnotationData(viewRoot.getViewId(), LoginView.class);
        if (loginView == null || loginView.value() == null || loginView.value().isEmpty()) {
            this.log.debug((Object)"Returning 401 response (login required)");
            context.getExternalContext().setResponseStatus(401);
            context.responseComplete();
            return;
        }
        String loginViewId = loginView.value();
        this.log.debugf("Redirecting to configured LoginView %s", (Object)loginViewId);
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        navHandler.handleNavigation(context, "", loginViewId);
        context.renderResponse();
    }

    private void redirectToAccessDeniedView(FacesContext context, UIViewRoot viewRoot) {
        AccessDeniedView accessDeniedView = (AccessDeniedView)this.viewConfigStore.getAnnotationData(viewRoot.getViewId(), AccessDeniedView.class);
        if (accessDeniedView == null || accessDeniedView.value() == null || accessDeniedView.value().isEmpty()) {
            this.log.debug((Object)"Returning 401 response (access denied)");
            context.getExternalContext().setResponseStatus(401);
            context.responseComplete();
            return;
        }
        String accessDeniedViewId = accessDeniedView.value();
        this.log.debugf("Redirecting to configured AccessDenied %s", (Object)accessDeniedViewId);
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        navHandler.handleNavigation(context, "", accessDeniedViewId);
        context.renderResponse();
    }

    public void observePreNavigateEvent(@Observes PreNavigateEvent event) {
        FacesContext context;
        this.log.debugf("PreNavigateEvent observed %s, %s", (Object)event.getOutcome(), (Object)event.getFromAction());
        if ("success".equals(event.getOutcome()) && "#{identity.login}".equals(event.getFromAction()) && (context = event.getContext()).getExternalContext().getSessionMap().get(PRE_LOGIN_VIEW) != null) {
            String oldViewId = (String)context.getExternalContext().getSessionMap().get(PRE_LOGIN_VIEW);
            NavigationHandler navHandler = context.getApplication().getNavigationHandler();
            navHandler.handleNavigation(context, "", oldViewId);
            context.renderResponse();
            context.getExternalContext().getSessionMap().remove(PRE_LOGIN_VIEW);
        }
    }
}

