/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.view.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.faces.view.config.SecurityPhaseListener;
import org.jboss.seam.faces.view.config.ViewConfigExtension;
import org.jboss.seam.faces.view.config.ViewConfigStore;

@ApplicationScoped
public class ViewConfigStoreImpl
implements ViewConfigStore {
    private final transient Logger log = Logger.getLogger(SecurityPhaseListener.class);
    private final ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, List<? extends Annotation>>> annotationCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, List<? extends Annotation>>> qualifierCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, Annotation>> viewPatternDataByAnnotation = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, List<? extends Annotation>>> viewPatternDataByQualifier = new ConcurrentHashMap();

    @Inject
    public void setup(ViewConfigExtension extension) {
        for (Map.Entry<String, Set<Annotation>> e : extension.getData().entrySet()) {
            for (Annotation i : e.getValue()) {
                this.addAnnotationData(e.getKey(), i);
            }
        }
    }

    public synchronized void addAnnotationData(String viewId, Annotation annotation) {
        Annotation[] annotations;
        ConcurrentHashMap<String, Annotation> annotationMap = this.viewPatternDataByAnnotation.get(annotation.annotationType());
        if (annotationMap == null) {
            annotationMap = new ConcurrentHashMap();
            this.viewPatternDataByAnnotation.put(annotation.annotationType(), annotationMap);
            this.log.debugf("Putting new annotation map for anotation type %s", (Object)annotation.annotationType().getName());
        }
        annotationMap.put(viewId, annotation);
        this.log.debugf("Putting new annotation (type: %s) for viewId: %s", (Object)annotation.annotationType().getName(), (Object)viewId);
        for (Annotation qualifier : annotations = annotation.annotationType().getAnnotations()) {
            if (qualifier.annotationType().getName().startsWith("java.")) {
                this.log.debugf("Disregarding java.* package %s", (Object)qualifier.annotationType().getName());
                continue;
            }
            ConcurrentHashMap<String, List<Annotation>> qualifierMap = this.viewPatternDataByQualifier.get(qualifier.annotationType());
            if (qualifierMap == null) {
                qualifierMap = new ConcurrentHashMap();
                this.viewPatternDataByQualifier.put(qualifier.annotationType(), qualifierMap);
                this.log.debugf("Putting new qualifier map for qualifier type %s", (Object)qualifier.annotationType().getName());
            }
            ArrayList<Annotation> qualifiedAnnotations = new ArrayList<Annotation>();
            List<Annotation> exisitngQualifiedAnnotations = qualifierMap.get(viewId);
            if (exisitngQualifiedAnnotations != null && !exisitngQualifiedAnnotations.isEmpty()) {
                qualifiedAnnotations.addAll(exisitngQualifiedAnnotations);
            }
            qualifiedAnnotations.add(annotation);
            this.log.debugf("Adding new annotation (type: %s) for viewId: %s and Qualifier %s", (Object)annotation.annotationType().getName(), (Object)viewId, (Object)qualifier.annotationType().getName());
            qualifierMap.put(viewId, qualifiedAnnotations);
        }
    }

    public <T extends Annotation> T getAnnotationData(String viewId, Class<T> type) {
        List<T> data = this.prepareAnnotationCache(viewId, type, this.annotationCache, this.viewPatternDataByAnnotation);
        if (data != null && data.size() > 0) {
            return (T)((Annotation)data.get(0));
        }
        return null;
    }

    public <T extends Annotation> List<T> getAllAnnotationData(String viewId, Class<T> type) {
        List<T> data = this.prepareAnnotationCache(viewId, type, this.annotationCache, this.viewPatternDataByAnnotation);
        if (data != null) {
            return Collections.unmodifiableList(data);
        }
        return null;
    }

    public List<? extends Annotation> getAllQualifierData(String viewId, Class<? extends Annotation> qualifier) {
        List<? extends Annotation> data = this.prepareQualifierCache(viewId, qualifier, this.qualifierCache, this.viewPatternDataByQualifier);
        if (data != null) {
            return Collections.unmodifiableList(data);
        }
        return null;
    }

    private <T extends Annotation> List<T> prepareAnnotationCache(String viewId, Class<T> annotationType, ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, List<? extends Annotation>>> cache, ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, Annotation>> viewPatternData) {
        ArrayList annotationData;
        ConcurrentHashMap newMap;
        ConcurrentHashMap<String, List<Annotation>> map = cache.get(annotationType);
        if (map == null && (map = cache.putIfAbsent(annotationType, newMap = new ConcurrentHashMap())) == null) {
            map = newMap;
        }
        if ((annotationData = map.get(viewId)) == null) {
            ArrayList newList = new ArrayList();
            Map viewPatterns = viewPatternData.get(annotationType);
            if (viewPatterns != null) {
                List<String> resultingViews = this.findViewsWithPatternsThatMatch(viewId, viewPatterns.keySet());
                for (String i : resultingViews) {
                    newList.add(viewPatterns.get(i));
                }
            }
            if ((annotationData = (ArrayList)map.putIfAbsent(viewId, newList)) == null) {
                annotationData = newList;
            }
        }
        return annotationData;
    }

    private <T extends Annotation> List<T> prepareQualifierCache(String viewId, Class<T> qualifierType, ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, List<? extends Annotation>>> cache, ConcurrentHashMap<Class<? extends Annotation>, ConcurrentHashMap<String, List<? extends Annotation>>> viewPatternData) {
        ArrayList annotationData;
        ConcurrentHashMap newMap;
        ConcurrentHashMap<String, List<Annotation>> map = cache.get(qualifierType);
        if (map == null && (map = cache.putIfAbsent(qualifierType, newMap = new ConcurrentHashMap())) == null) {
            map = newMap;
        }
        if ((annotationData = map.get(viewId)) == null) {
            ArrayList newList = new ArrayList();
            Map viewPatterns = viewPatternData.get(qualifierType);
            if (viewPatterns != null) {
                List<String> resultingViews = this.findViewsWithPatternsThatMatch(viewId, viewPatterns.keySet());
                for (String i : resultingViews) {
                    newList.addAll((Collection)viewPatterns.get(i));
                }
            }
            Collections.sort(newList, new AnnotationNameComparator());
            annotationData = map.putIfAbsent(viewId, newList);
            if (annotationData == null) {
                annotationData = newList;
            }
        }
        return annotationData;
    }

    private List<String> findViewsWithPatternsThatMatch(String viewId, Set<String> viewPatterns) {
        ArrayList<String> resultingViews = new ArrayList<String>();
        for (String viewPattern : viewPatterns) {
            if (viewPattern.endsWith("*")) {
                String cutView = viewPattern.substring(0, viewPattern.length() - 1);
                if (!viewId.startsWith(cutView)) continue;
                resultingViews.add(viewPattern);
                continue;
            }
            if (!viewPattern.equals(viewId)) continue;
            resultingViews.add(viewPattern);
        }
        Collections.sort(resultingViews, StringLengthComparator.INSTANCE);
        return resultingViews;
    }

    private static class AnnotationNameComparator
    implements Comparator<Annotation> {
        public static final StringLengthComparator INSTANCE = new StringLengthComparator();

        private AnnotationNameComparator() {
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            return o1.annotationType().getName().compareTo(o2.annotationType().getName());
        }
    }

    private static class StringLengthComparator
    implements Comparator<String> {
        public static final StringLengthComparator INSTANCE = new StringLengthComparator();

        private StringLengthComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return 0;
        }
    }
}

