/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.context;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.inject.Named;
import org.jboss.seam.faces.context.RenderContext;
import org.jboss.seam.faces.context.RenderContextImpl;
import org.jboss.seam.faces.context.RenderScoped;
import org.jboss.seam.faces.util.BeanManagerUtils;
import org.jboss.seam.solder.beanManager.BeanManagerLocator;

@RequestScoped
public class RenderScopedContext
implements Context,
PhaseListener,
Serializable {
    private static final long serialVersionUID = -1580689204988513798L;
    private static final String SESSION_KEY_PREFIX = RenderScopedContext.class.getName() + ".context";
    private static final String COMPONENT_MAP_NAME = RenderScopedContext.class.getName() + ".componentInstanceMap";
    private static final String CREATIONAL_MAP_NAME = RenderScopedContext.class.getName() + ".creationalInstanceMap";
    public static final String RENDER_SCOPE_URL_KEY = RenderScopedContext.class.getName() + ".url.key";
    String requestParameterName = "fid";
    RenderContext currentContext = null;

    @Produces
    @Named
    @RequestScoped
    public RenderContext getContextInstance() {
        if (this.currentContext == null) {
            this.initializeCurrentContext();
        }
        return this.currentContext;
    }

    private RenderContext getCurrentRenderContext() {
        BeanManager manager = new BeanManagerLocator().getBeanManager();
        return BeanManagerUtils.getContextualInstance(manager, RenderContext.class);
    }

    private void assertActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("Seam context with scope annotation @RenderScoped is not active with respect to the current thread. This is probably caused by attempting to access the Flash before it was created or after it was destroyed.");
        }
    }

    private void initializeCurrentContext() {
        RenderContextImpl context;
        Integer currentId = this.getCurrentId();
        if (currentId != null && this.savedContextExists(currentId)) {
            context = this.getRenderContextMap().get(currentId);
            this.currentContext = context;
        }
        if (this.currentContext == null) {
            context = new RenderContextImpl();
            context.setId(this.getNextRenderContextId());
            this.getRenderContextMap().put(context.getId(), context);
            this.currentContext = context;
        }
    }

    private int getNextRenderContextId() {
        Map<Integer, RenderContext> renderContextMap = this.getRenderContextMap();
        int id = 0;
        while (renderContextMap.containsKey(id)) {
            ++id;
        }
        return id;
    }

    private boolean savedContextExists(int id) {
        return this.getRenderContextMap().get(id) instanceof RenderContext;
    }

    private Integer getCurrentId() {
        if (this.countRenderContexts() == 1) {
            return this.getRenderContextMap().keySet().iterator().next();
        }
        Map requestParameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String currentId = (String)requestParameterMap.get(this.requestParameterName);
        Integer result = null;
        try {
            if (currentId != null) {
                result = Integer.valueOf(currentId);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    public void afterPhase(PhaseEvent event) {
        RenderContext contextInstance;
        if (PhaseId.RENDER_RESPONSE.equals(event.getPhaseId()) && (contextInstance = this.getContextInstance()) != null) {
            Integer id = contextInstance.getId();
            RenderContext removed = this.getRenderContextMap().remove(id);
            Map<Contextual<?>, Object> componentInstanceMap = this.getComponentInstanceMap();
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
            if (componentInstanceMap != null && creationalContextMap != null) {
                for (Map.Entry<Contextual<?>, Object> componentEntry : componentInstanceMap.entrySet()) {
                    Contextual<?> contextual = componentEntry.getKey();
                    Object instance = componentEntry.getValue();
                    CreationalContext<?> creational = creationalContextMap.get(contextual);
                    contextual.destroy(instance, creational);
                }
            }
        }
    }

    public void beforePhase(PhaseEvent arg0) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public <T> T get(Contextual<T> component) {
        this.assertActive();
        return (T)this.getComponentInstanceMap().get(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.assertActive();
        Object instance = this.get(component);
        if (instance == null) {
            Map<Contextual<?>, Object> componentInstanceMap;
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
            Map<Contextual<?>, Object> map = componentInstanceMap = this.getComponentInstanceMap();
            synchronized (map) {
                instance = componentInstanceMap.get(component);
                if (instance == null && (instance = component.create(creationalContext)) != null) {
                    componentInstanceMap.put(component, instance);
                    creationalContextMap.put(component, creationalContext);
                }
            }
        }
        return instance;
    }

    public boolean isActive() {
        return FacesContext.getCurrentInstance() != null;
    }

    public Class<? extends Annotation> getScope() {
        return RenderScoped.class;
    }

    private Map<Contextual<?>, Object> getComponentInstanceMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentRenderContext().get(COMPONENT_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.getCurrentRenderContext().put(COMPONENT_MAP_NAME, map);
        }
        return map;
    }

    private Map<Contextual<?>, CreationalContext<?>> getCreationalContextMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentRenderContext().get(CREATIONAL_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.getCurrentRenderContext().put(CREATIONAL_MAP_NAME, map);
        }
        return map;
    }

    private synchronized Map<Integer, RenderContext> getRenderContextMap() {
        ConcurrentHashMap<Integer, RenderContext> renderContextMap;
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        if (sessionMap.containsKey(SESSION_KEY_PREFIX)) {
            renderContextMap = (Map)sessionMap.get(SESSION_KEY_PREFIX);
        } else {
            renderContextMap = new ConcurrentHashMap();
            sessionMap.put(SESSION_KEY_PREFIX, renderContextMap);
        }
        return renderContextMap;
    }

    public int countRenderContexts() {
        return this.getRenderContextMap().size();
    }

    public String getRequestParameterName() {
        return this.requestParameterName;
    }
}

