/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.cluster.selenium;

import com.thoughtworks.selenium.Wait;
import java.io.IOException;
import java.text.MessageFormat;
import org.jboss.seam.example.common.test.selenium.SeamSelenium;
import org.jboss.seam.example.common.test.selenium.SeamSeleniumTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FailoverTest
extends SeamSeleniumTest {
    private final String HOTEL_NAME = "W Hotel";
    private final String DEFAULT_USERNAME = "demo";
    private final String DEFAULT_PASSWORD = "demo";
    private final String EXPECTED_NAME = "Demo User";
    private final String CREDIT_CARD = "0123456789012345";
    private final String CREDIT_CARD_NAME = "visa";
    private final long JBOSS_SHUTDOWN_TIMEOUT = 20000L;
    private final int SECOND_BROWSER_PORT = 8180;
    private final String SECOND_INSTANCE_BROWSER_URL = "http://localhost:8180";
    private SeamSelenium browser2;

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.deleteCookies(browser);
        this.browser2 = this.startSecondBrowser();
        this.deleteCookies(this.browser2);
        AssertJUnit.assertTrue((String)"Login failed.", (boolean)this.login(browser));
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.logout(this.browser2);
        super.tearDown();
        this.stopSecondBrowser();
    }

    @Test
    public void simpleBookingWithFailoverTest() {
        this.preFailurePart(browser);
        String newAddress = this.getAddressForSecondInstance(browser);
        this.shutdownMasterJBossInstance();
        this.postFailurePart(this.browser2, newAddress);
        String message = this.browser2.getText(this.getProperty("HOTEL_MESSAGE"));
        AssertJUnit.assertTrue((String)"Booking failed. Confirmation message does not match.", (boolean)message.matches(MessageFormat.format(this.getProperty("BOOKING_CONFIRMATION_MESSAGE"), "Demo User", "W Hotel")));
    }

    public void shutdownMasterJBossInstance() {
        String command = "";
        command = CONTAINER.contains("jboss6") ? JBOSS_HOME + "/bin/shutdown.sh -s service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi -S" : JBOSS_HOME + "/bin/shutdown.sh -s localhost:1099 -S";
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            Thread.sleep(20000L);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void preFailurePart(SeamSelenium browser) {
        if (!this.isLoggedIn(browser)) {
            AssertJUnit.fail();
        }
        if (!browser.isElementPresent(this.getProperty("SEARCH_SUBMIT"))) {
            browser.open(this.CONTEXT_PATH + this.getProperty("MAIN_PAGE"));
            browser.waitForPageToLoad(TIMEOUT);
        }
        this.enterSearchQueryUsingAJAX(browser, "W Hotel");
        browser.click(this.getProperty("SEARCH_RESULT_TABLE_FIRST_ROW_LINK"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.click(this.getProperty("BOOKING_BOOK"));
        browser.waitForPageToLoad(TIMEOUT);
    }

    public void postFailurePart(SeamSelenium browser, String newAddress) {
        this.browser2.open(newAddress);
        this.populateBookingFields(browser);
        this.deleteCookies(browser);
        browser.click(this.getProperty("HOTEL_PROCEED"));
        browser.waitForPageToLoad(TIMEOUT);
        this.deleteCookies(browser);
        browser.click(this.getProperty("HOTEL_CONFIRM"));
        browser.waitForPageToLoad(TIMEOUT);
    }

    public SeamSelenium startSecondBrowser() {
        BROWSER_URL = "http://localhost:8180";
        return super.startBrowser();
    }

    public void stopSecondBrowser() {
        this.browser2.stop();
    }

    public String getAddressForSecondInstance(SeamSelenium browser) {
        String[] parsedStrings = browser.getLocation().split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 3; i != parsedStrings.length; ++i) {
            sb.append("/").append(parsedStrings[i]);
        }
        String sid = browser.getCookieByName("JSESSIONID");
        String newAddress = sb.toString();
        String firstPart = newAddress.substring(0, newAddress.indexOf("?"));
        String secondPart = newAddress.substring(newAddress.indexOf("?"), newAddress.length());
        newAddress = firstPart + ";jsessionid=" + sid + secondPart;
        return newAddress;
    }

    protected void populateBookingFields(SeamSelenium browser) {
        this.populateBookingFields(browser, 2, 0, "0123456789012345", "visa");
    }

    protected void populateBookingFields(SeamSelenium browser, int bed, int smoking, String creditCard, String creditCardName) {
        browser.select(this.getProperty("HOTEL_BED_FIELD"), this.getProperty("HOTEL_BED_FIELD_SELECT_CRITERIA") + bed);
        if (smoking == 1) {
            browser.check(this.getProperty("HOTEL_SMOKING_1"));
        } else {
            browser.check(this.getProperty("HOTEL_SMOKING_2"));
        }
        browser.type(this.getProperty("HOTEL_CREDIT_CARD"), creditCard);
        browser.type(this.getProperty("HOTEL_CREDIT_CARD_NAME"), creditCardName);
    }

    private void deleteCookies(SeamSelenium browser) {
        browser.deleteAllVisibleCookies();
    }

    public boolean login(SeamSelenium browser) {
        return this.login(browser, "demo", "demo");
    }

    public boolean login(SeamSelenium browser, String username, String password) {
        if (this.isLoggedIn(browser)) {
            AssertJUnit.fail((String)"User already logged in.");
        }
        browser.open(this.CONTEXT_PATH + this.getProperty("HOME_PAGE"));
        browser.waitForPageToLoad(TIMEOUT);
        if (!browser.getTitle().equals(this.getProperty("PAGE_TITLE"))) {
            return false;
        }
        browser.type(this.getProperty("LOGIN_USERNAME_FIELD"), username);
        browser.type(this.getProperty("LOGIN_PASSWORD_FIELD"), password);
        browser.click(this.getProperty("LOGIN_SUBMIT"));
        browser.waitForPageToLoad(TIMEOUT);
        return this.isLoggedIn(browser);
    }

    public void logout(SeamSelenium browser) {
        if (this.isLoggedIn(browser)) {
            browser.click(this.getProperty("LOGOUT"));
            browser.waitForPageToLoad(TIMEOUT);
        }
    }

    public boolean isLoggedIn(SeamSelenium browser) {
        return browser.isElementPresent(this.getProperty("LOGOUT"));
    }

    public void enterSearchQueryUsingAJAX(final SeamSelenium browser, String query) {
        browser.type(this.getProperty("SEARCH_STRING_FIELD"), "");
        browser.type(this.getProperty("SEARCH_STRING_FIELD"), query.substring(0, query.length() - 1));
        browser.typeKeys(this.getProperty("SEARCH_STRING_FIELD"), query.substring(query.length() - 1));
        browser.click(this.getProperty("SEARCH_SUBMIT"));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        new Wait(){

            public boolean until() {
                return !browser.isVisible(FailoverTest.this.getProperty("SPINNER"));
            }
        }.wait("Spinner hasn't come out.");
        new Wait(){

            public boolean until() {
                return browser.isElementPresent(FailoverTest.this.getProperty("SEARCH_RESULT_TABLE")) || browser.isElementPresent(FailoverTest.this.getProperty("NO_HOTELS_FOUND"));
            }
        }.wait("Search results not found.");
    }
}

