/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.selenium;

import org.jboss.seam.example.common.test.booking.selenium.SeleniumBookingTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChangePasswordTest
extends SeleniumBookingTest {
    private static final String LONG_TEXT = "testertestertest";
    private static final String SHORT_TEXT = "tt";
    private final String USERNAME = "gavin";
    private final String PASSWORD = "foobar";

    @Override
    @BeforeMethod
    public void setUp() {
        browser = this.startBrowser();
        AssertJUnit.assertTrue((String)"Login failed.", (boolean)this.login("gavin", "foobar"));
    }

    @Test
    public void changePasswordTest() {
        this.changePassword("password");
        AssertJUnit.assertTrue((String)"Password change failed.", (boolean)browser.isTextPresent(this.getProperty("PASSWORD_UPDATED_MESSAGE")));
        this.logout();
        AssertJUnit.assertTrue((String)"Login failed.", (boolean)this.login("gavin", "password"));
        this.changePassword("foobar");
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"Password change failed.", (boolean)browser.isTextPresent(this.getProperty("PASSWORD_UPDATED_MESSAGE")));
        this.logout();
        AssertJUnit.assertTrue((String)"Login failed.", (boolean)this.login("gavin", "foobar"));
    }

    @Test
    public void usingDifferentPasswordsTest() {
        this.changePassword("password", "password1");
        AssertJUnit.assertTrue((String)"Password verification failed", (boolean)browser.isTextPresent(this.getProperty("PASSWORD_REENTER_MESSAGE")));
    }

    @Test
    public void usingEmptyPasswordsTest() {
        this.changePassword("", "");
        AssertJUnit.assertEquals((String)"Password validation failed", (Object)2, (Object)browser.getXpathCount(this.getProperty("PASSWORD_VALUE_REQUIRED_MESSAGE")));
    }

    @Test
    public void usingLongPasswordTest() {
        this.changePassword(LONG_TEXT, LONG_TEXT);
        AssertJUnit.assertTrue((String)"Password validation failed", (boolean)browser.isTextPresent(this.getProperty("PASSWORD_LENGTH_MESSAGE")));
    }

    @Test
    public void usingShortPasswordTest() {
        this.changePassword(SHORT_TEXT, SHORT_TEXT);
        AssertJUnit.assertTrue((String)"Password validation failed", (boolean)browser.isTextPresent(this.getProperty("PASSWORD_LENGTH_MESSAGE")));
    }

    public void changePassword(String newPassword) {
        this.changePassword(newPassword, newPassword);
    }

    public void changePassword(String newPassword, String verify) {
        browser.click(this.getProperty("SETTINGS"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.type(this.getProperty("PASSWORD_PASSWORD"), newPassword);
        browser.type(this.getProperty("PASSWORD_VERIFY"), verify);
        browser.click(this.getProperty("PASSWORD_SUBMIT"));
        this.waitForForm();
    }
}

