/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.webdriver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.seam.example.common.test.webdriver.AjaxWebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class DelegatedWebElement
implements AjaxWebElement {
    private int waitTime;
    private WebElement element;

    public DelegatedWebElement(WebElement element) {
        this(element, 3000);
    }

    public DelegatedWebElement(WebElement element, int waitTime) {
        this.element = element;
        this.waitTime = waitTime;
    }

    public void clear() {
        this.element.clear();
    }

    @Override
    public void clearAndSendKeys(CharSequence ... keysToSend) {
        this.element.clear();
        this.element.sendKeys(keysToSend);
    }

    public void click() {
        this.element.click();
    }

    @Override
    public void clickAndWait() {
        this.element.click();
        try {
            Thread.sleep(this.waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void clickAndWait(int millis) {
        this.element.click();
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public AjaxWebElement findElement(By by) {
        return new DelegatedWebElement(this.element.findElement(by));
    }

    public List<WebElement> findElements(By by) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        List original = this.element.findElements(by);
        if (original == null || original.size() == 0) {
            return Collections.emptyList();
        }
        for (WebElement e : original) {
            elements.add(new DelegatedWebElement(e));
        }
        return elements;
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public String getCssValue(String propertyName) {
        return this.element.getCssValue(propertyName);
    }

    public Point getLocation() {
        return this.element.getLocation();
    }

    public Dimension getSize() {
        return this.element.getSize();
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public String getText() {
        return this.element.getText();
    }

    public boolean isDisplayed() {
        return this.element.isDisplayed();
    }

    public boolean isEnabled() {
        return this.element.isEnabled();
    }

    public boolean isSelected() {
        return this.element.isSelected();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.element.sendKeys(keysToSend);
    }

    @Override
    public void setWaitTime(int millis) {
        this.waitTime = millis;
    }

    public void submit() {
        this.element.submit();
    }
}

