/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.jxl;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.imageio.ImageIO;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.jxl.CellInfo;
import org.jboss.seam.excel.jxl.JXLHelper;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UIColumn;
import org.jboss.seam.excel.ui.UIHyperlink;
import org.jboss.seam.excel.ui.UIImage;
import org.jboss.seam.excel.ui.UILink;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.excel.ui.command.Command;
import org.jboss.seam.excel.ui.command.UIGroupColumns;
import org.jboss.seam.excel.ui.command.UIGroupRows;
import org.jboss.seam.excel.ui.command.UIMergeCells;
import org.jboss.seam.excel.ui.command.UIRowPageBreak;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLExcelWorkbook
implements ExcelWorkbook {
    private static final int CELL_DEFAULT_HEIGHT = 17;
    private static final int CELL_DEFAULT_WIDTH = 64;
    private Log log = Logging.getLog(this.getClass());
    private static final int MAX_COLUMNS = 255;
    private static final int MAX_ROWS = 65535;
    private static final String DEFAULT_WORKSHEET_NAME = "Sheet{0}";
    private ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
    private WritableWorkbook workbook;
    private WritableSheet worksheet;
    private int startRowIndex = 0;
    private int currentRowIndex = 0;
    private int startColumnIndex = 0;
    private int currentColumnIndex = 0;
    private int currentWorksheetIndex = 0;
    private int maxRowIndex;
    private JXLHelper jxlHelper = new JXLHelper();

    private void nextRow() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Moving from row #0 to #1", new Object[]{this.currentRowIndex, this.currentRowIndex + 1});
        }
        ++this.currentRowIndex;
        if (this.currentRowIndex >= 65535) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Excel only supports {0} rows", new Object[]{255}));
        }
    }

    @Override
    public void nextColumn() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Moving from column #0 to #1", new Object[]{this.currentColumnIndex, this.currentColumnIndex + 1});
        }
        ++this.currentColumnIndex;
        if (this.currentColumnIndex > 255) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Excel doesn't support more than {0} columns", new Object[]{255}));
        }
        if (this.currentRowIndex > this.maxRowIndex) {
            this.maxRowIndex = this.currentRowIndex;
        }
        this.currentRowIndex = this.startRowIndex;
    }

    private boolean workbookContainsSheet(String name) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Checking if workbook contains sheet named #0", new Object[]{name});
        }
        if (this.workbook == null) {
            throw new ExcelWorkbookException("Can't search for sheets before creating a workbook");
        }
        boolean found = false;
        for (String sheetName : this.workbook.getSheetNames()) {
            if (!sheetName.equalsIgnoreCase(name)) continue;
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Result: #0", new Object[]{found});
        }
        return found;
    }

    @Override
    public void createOrSelectWorksheet(UIWorksheet uiWorksheet) {
        if (this.workbook == null) {
            throw new ExcelWorkbookException("You cannot create a worksheet before creating a workbook");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating worksheet named #0 starting at column #1 and row #2", new Object[]{uiWorksheet.getName(), uiWorksheet.getStartColumn(), uiWorksheet.getStartRow()});
        }
        if (this.workbookContainsSheet(uiWorksheet.getName())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Sheet found, selecting", new Object[0]);
            }
            this.worksheet = this.workbook.getSheet(uiWorksheet.getName());
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Sheet not found, creating", new Object[0]);
            }
            String name = uiWorksheet.getName() != null ? uiWorksheet.getName() : Interpolator.instance().interpolate(DEFAULT_WORKSHEET_NAME, new Object[]{this.currentWorksheetIndex + 1});
            this.worksheet = this.workbook.createSheet(name, this.currentWorksheetIndex);
        }
        this.jxlHelper.applyWorksheetSettings(this.worksheet, uiWorksheet);
        ++this.currentWorksheetIndex;
        this.currentColumnIndex = this.startColumnIndex = uiWorksheet.getStartColumn() == null ? 0 : uiWorksheet.getStartColumn();
        this.maxRowIndex = this.currentRowIndex = (this.startRowIndex = uiWorksheet.getStartRow() == null ? 0 : uiWorksheet.getStartRow());
    }

    private void addCell(UICell uiCell) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Adding a cell with data #1 at column #2 and row #3", new Object[]{uiCell.getValue(), this.currentColumnIndex, this.currentRowIndex});
        }
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("Can't add cells before creating worksheet");
        }
        int useRow = uiCell.getRow() != null ? uiCell.getRow() : this.currentRowIndex;
        int useColumn = uiCell.getColumn() != null ? uiCell.getColumn() : this.currentColumnIndex;
        CellInfo cellInfo = this.jxlHelper.getCellInfo(uiCell);
        WritableCell cell = JXLHelper.createCell(useColumn, useRow, cellInfo.getCellType(), uiCell.getValue(), cellInfo.getCellFormat());
        if (cellInfo.getCellFeatures() != null) {
            cell.setCellFeatures(cellInfo.getCellFeatures());
        }
        try {
            this.worksheet.addCell(cell);
        }
        catch (WriteException e) {
            throw new ExcelWorkbookException("Could not add cell", e);
        }
        if (uiCell.getColumn() == null && uiCell.getRow() == null) {
            this.nextRow();
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Returning bytes from workbook", new Object[0]);
        }
        if (this.workbook == null) {
            throw new ExcelWorkbookException("You can't get workbook data before creating a workbook");
        }
        if (this.workbook.getSheets().length == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Creating dummy sheet", new Object[0]);
            }
            this.workbook.createSheet("dummy", 0);
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (WriteException e) {
            throw new ExcelWorkbookException("There was an exception writing the workbook", e);
        }
        catch (IOException e) {
            throw new ExcelWorkbookException("There was an exception closing the workbook", e);
        }
        return this.byteStream.toByteArray();
    }

    @Override
    public void createWorkbook(UIWorkbook uiWorkbook) {
        String urlString = uiWorkbook.getTemplateURI();
        InputStream templateStream = null;
        if (urlString != null) {
            try {
                templateStream = urlString.indexOf("://") < 0 ? this.getClass().getResourceAsStream(urlString) : new URL(urlString).openStream();
            }
            catch (Exception e) {
                throw new ExcelWorkbookException("Could not handle template URI", e);
            }
        }
        WorkbookSettings workbookSettings = null;
        if (uiWorkbook.hasSettings()) {
            workbookSettings = this.jxlHelper.createWorkbookSettings(uiWorkbook);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating workbook with creation type #0", new Object[]{uiWorkbook.getCreationType()});
        }
        try {
            switch (uiWorkbook.getCreationType()) {
                case WITH_SETTNGS_AND_TEMPLATE: {
                    this.workbook = Workbook.createWorkbook((OutputStream)this.byteStream, (Workbook)Workbook.getWorkbook((InputStream)templateStream), (WorkbookSettings)workbookSettings);
                    break;
                }
                case WITH_SETTINGS_WITHOUT_TEMPLATE: {
                    this.workbook = Workbook.createWorkbook((OutputStream)this.byteStream, (WorkbookSettings)workbookSettings);
                    break;
                }
                case WITHOUT_SETTINGS_WITH_TEMPLATE: {
                    this.workbook = Workbook.createWorkbook((OutputStream)this.byteStream, (Workbook)Workbook.getWorkbook((InputStream)templateStream));
                    break;
                }
                case WITHOUT_SETTINGS_OR_TEMPLATE: {
                    this.workbook = Workbook.createWorkbook((OutputStream)this.byteStream);
                }
            }
        }
        catch (Exception e) {
            throw new ExcelWorkbookException("Could not create workbook", e);
        }
        if (uiWorkbook.getWorkbookProtected() != null) {
            this.workbook.setProtected(uiWorkbook.getWorkbookProtected().booleanValue());
        }
        this.currentWorksheetIndex = this.workbook.getNumberOfSheets();
    }

    @Override
    public DocumentData.DocumentType getDocumentType() {
        return new DocumentData.DocumentType("xls", "application/vnd.ms-excel");
    }

    @Override
    public void applyColumnSettings(UIColumn uiColumn) {
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("You can't set column settings before creating a worksheet");
        }
        this.jxlHelper.applyColumnSettings(uiColumn, this.worksheet, this.currentColumnIndex);
    }

    private void addImage(UIImage uiImage) {
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("Can't add an image before creating a worksheet");
        }
        BufferedImage image = null;
        ByteArrayOutputStream pngStream = null;
        try {
            image = ImageIO.read(new URI(uiImage.getURI()).toURL());
            pngStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", pngStream);
        }
        catch (Exception e) {
            throw new ExcelWorkbookException("Could not load or process image", e);
        }
        int useStartColumn = uiImage.getStartColumn() == null ? this.currentColumnIndex : uiImage.getStartRow();
        int useStartRow = uiImage.getStartRow() == null ? this.currentRowIndex : uiImage.getStartRow();
        double estimatedRowSpan = (double)image.getHeight() / 17.0;
        double estimatedColSpan = (double)image.getWidth() / 64.0;
        double useColumnSpan = uiImage.getColumnSpan() == null ? estimatedRowSpan : uiImage.getColumnSpan();
        double useRowSpan = uiImage.getRowSpan() == null ? estimatedColSpan : uiImage.getRowSpan();
        this.worksheet.addImage(new WritableImage((double)useStartColumn, (double)useStartRow, useColumnSpan, useRowSpan, pngStream.toByteArray()));
    }

    private void addHyperlink(UIHyperlink uiHyperlink) {
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("Can't add a hyperlink before creating a worksheet");
        }
        int useStartColumn = uiHyperlink.getStartColumn() == null ? this.currentColumnIndex : uiHyperlink.getStartColumn();
        int useStartRow = uiHyperlink.getStartRow() == null ? this.currentRowIndex : uiHyperlink.getStartRow();
        int useEndColumn = uiHyperlink.getEndColumn() == null ? useStartColumn : uiHyperlink.getEndColumn();
        int useEndRow = uiHyperlink.getEndRow() == null ? useStartRow : uiHyperlink.getEndRow();
        String useDescription = uiHyperlink.getDescription() == null ? uiHyperlink.getURL() : uiHyperlink.getDescription();
        URL useURL = null;
        try {
            useURL = new URL(uiHyperlink.getURL());
        }
        catch (MalformedURLException e) {
            throw new ExcelWorkbookException("Bad url", e);
        }
        try {
            this.worksheet.addHyperlink(new WritableHyperlink(useStartColumn, useStartRow, useEndColumn, useEndRow, useURL, useDescription));
        }
        catch (Exception e) {
            throw new ExcelWorkbookException("Could not add hyperlink", e);
        }
    }

    @Override
    public void addItem(WorksheetItem item) {
        if (!((UIComponent)item).isRendered()) {
            return;
        }
        if (item.getValue() == null) {
            if (item.getColumn() == null && item.getRow() == null) {
                this.nextRow();
            }
            return;
        }
        switch (item.getItemType()) {
            case cell: {
                this.addCell((UICell)item);
                break;
            }
            case hyperlink: {
                this.addHyperlink((UIHyperlink)item);
                break;
            }
            case image: {
                this.addImage((UIImage)item);
                break;
            }
            default: {
                throw new ExcelWorkbookException(Interpolator.instance().interpolate("Unknown item type {0}", new Object[]{item.getItemType()}));
            }
        }
    }

    @Override
    public void executeCommand(Command command) {
        switch (command.getCommandType()) {
            case merge_cells: {
                this.mergeCells((UIMergeCells)command);
                break;
            }
            case group_columns: {
                this.groupColumns((UIGroupColumns)command);
                break;
            }
            case group_rows: {
                this.groupRows((UIGroupRows)command);
                break;
            }
            case add_row_pagebreak: {
                this.addRowPageBreak((UIRowPageBreak)command);
                break;
            }
            default: {
                throw new ExcelWorkbookException(Interpolator.instance().interpolate("Unknown command #0", new Object[]{command.getCommandType()}));
            }
        }
    }

    private void addRowPageBreak(UIRowPageBreak command) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Adding row page break #0", new Object[]{command});
        }
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("Can't add row page breaks before creating a worksheet");
        }
        int useRow = command.getRow() != null ? command.getRow() : this.currentRowIndex;
        this.worksheet.addRowPageBreak(useRow);
    }

    private void groupRows(UIGroupRows command) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Grouping rows #0", new Object[]{command});
        }
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("Can't group rows before creating a worksheet");
        }
        if (command.getStartRow() == null || command.getEndRow() == null) {
            throw new ExcelWorkbookException("Must define starting and ending rows when grouping rows");
        }
        boolean collapse = command.getCollapse() == null ? false : command.getCollapse();
        try {
            this.worksheet.setRowGroup(command.getStartRow().intValue(), command.getEndRow().intValue(), collapse);
        }
        catch (Exception e) {
            throw new ExcelWorkbookException("Could not group columns", e);
        }
    }

    private void groupColumns(UIGroupColumns command) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Grouping columns #0", new Object[]{command});
        }
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("Can't group columns before creating a worksheet");
        }
        if (command.getStartColumn() == null || command.getEndColumn() == null) {
            throw new ExcelWorkbookException("Must define starting and ending columns when grouping columns");
        }
        for (int i = command.getStartColumn().intValue(); i <= command.getEndColumn(); ++i) {
            this.worksheet.setColumnView(i, new CellView());
        }
        boolean collapse = command.getCollapse() == null ? false : command.getCollapse();
        try {
            this.worksheet.setColumnGroup(command.getStartColumn().intValue(), command.getEndColumn().intValue(), collapse);
        }
        catch (Exception e) {
            throw new ExcelWorkbookException("Could not group columns", e);
        }
    }

    private void mergeCells(UIMergeCells command) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Merging cells #0", new Object[]{command});
        }
        if (this.worksheet == null) {
            throw new ExcelWorkbookException("Can't merge cells before creating a worksheet");
        }
        if (command.getStartColumn() == null || command.getStartRow() == null || command.getEndColumn() == null || command.getEndRow() == null) {
            throw new ExcelWorkbookException("All start/end columns/rows must be set when merging cells");
        }
        try {
            this.worksheet.mergeCells(command.getStartColumn().intValue(), command.getStartRow().intValue(), command.getEndColumn().intValue(), command.getEndRow().intValue());
        }
        catch (Exception e) {
            throw new ExcelWorkbookException("Couldn't merge cells", e);
        }
    }

    @Override
    public void addWorksheetFooter(WorksheetItem item, int colspan) {
        this.currentColumnIndex = this.startColumnIndex;
        this.currentRowIndex = this.maxRowIndex;
        UIMergeCells mergeCommand = new UIMergeCells();
        mergeCommand.setStartColumn(this.currentColumnIndex);
        mergeCommand.setStartRow(this.currentRowIndex);
        mergeCommand.setEndColumn(this.currentColumnIndex + colspan - 1);
        mergeCommand.setEndRow(this.currentRowIndex);
        this.executeCommand(mergeCommand);
        this.addItem(item);
    }

    @Override
    public void addWorksheetHeader(WorksheetItem item, int colspan) {
        UIMergeCells mergeCommand = new UIMergeCells();
        mergeCommand.setStartColumn(this.currentColumnIndex);
        mergeCommand.setStartRow(this.currentRowIndex);
        mergeCommand.setEndColumn(this.currentColumnIndex + colspan - 1);
        mergeCommand.setEndRow(this.currentRowIndex);
        this.executeCommand(mergeCommand);
        this.addItem(item);
        ++this.startRowIndex;
    }

    @Override
    public void setStylesheets(List<UILink> stylesheets) {
        try {
            this.jxlHelper.setStylesheets(stylesheets);
        }
        catch (Exception e) {
            throw new ExcelWorkbookException("Could not parse stylesheet", e);
        }
    }
}

