/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.flex;

import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.FlexFactory;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.log.ServletLogTarget;
import flex.messaging.services.RemotingService;
import flex.messaging.services.Service;
import flex.messaging.services.remoting.RemotingDestination;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.flex.FlexRemote;
import org.jboss.seam.flex.FlexSeamFactory;
import org.jboss.seam.flex.SeamAdapter;
import org.jboss.seam.flex.SeamFlexConfigurationManager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Reflections;

public class MessageBrokerManager {
    private static final String SEAM_ENDPOINT = "seam-amf";
    private static final LogProvider log = Logging.getLogProvider(MessageBrokerManager.class);
    private static String WAR_CONFIG_PREFIX = "/WEB-INF/flex/";
    private static String EAR_CONFIG_PREFIX = "/META-INF/flex/seam-default-";
    private MessageBroker broker;
    private ServletConfig servletConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.createThreadLocals();
        try {
            FlexContext.setThreadLocalObjects(null, null, null, null, null, (ServletConfig)servletConfig);
            ServletLogTarget.setServletContext((ServletContext)servletConfig.getServletContext());
            SeamFlexConfigurationManager configManager = new SeamFlexConfigurationManager();
            MessagingConfiguration config = configManager.getMessagingConfiguration(servletConfig);
            config.createLogAndTargets();
            this.broker = config.createBroker(servletConfig.getInitParameter("messageBrokerId"), Thread.currentThread().getContextClassLoader());
            FlexContext.setThreadLocalObjects(null, null, (MessageBroker)this.broker, null, null, (ServletConfig)servletConfig);
            this.setInitServletContext(this.broker, servletConfig.getServletContext());
            config.configureBroker(this.broker);
            if (this.broker.getChannelIds() == null || !this.broker.getChannelIds().contains(SEAM_ENDPOINT)) {
                log.info((Object)"seam-amf endpoint not found. creating...");
                this.broker.createEndpoint(SEAM_ENDPOINT, "http://{server.name}:{server.port}/{context.root}/messagebroker/seam-amf", "flex.messaging.endpoints.AMFEndpoint");
            }
            Object object = HttpFlexSession.mapLock;
            synchronized (object) {
                if (servletConfig.getServletContext().getAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP") == null) {
                    servletConfig.getServletContext().setAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP", new ConcurrentHashMap());
                }
            }
            this.broker.start();
            configManager.reportTokens();
            config.reportUnusedProperties();
            FlexContext.clearThreadLocalObjects();
        }
        catch (Throwable t) {
            log.error((Object)"MessageBrokerServlet failed to initialize due to runtime exception");
            this.destroy();
            throw new ServletException(t);
        }
    }

    private void setInitServletContext(MessageBroker broker, ServletContext ctx) throws Exception {
        Method setMethod = MessageBroker.class.getDeclaredMethod("setInitServletContext", ServletContext.class);
        setMethod.setAccessible(true);
        Reflections.invoke((Method)setMethod, (Object)broker, (Object[])new Object[]{ctx});
    }

    public void destroy() {
        if (this.broker != null) {
            this.broker.stop();
            this.destroyThreadLocals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) {
        log.info((Object)"=========== START FLEX REQUEST");
        try {
            this.broker.initThreadLocals();
            FlexContext.setThreadLocalObjects(null, null, (MessageBroker)this.broker, (HttpServletRequest)req, (HttpServletResponse)res, (ServletConfig)this.servletConfig);
            HttpFlexSession fs = HttpFlexSession.getFlexSession((HttpServletRequest)req);
            log.info((Object)("flex session is " + fs));
            Endpoint endpoint = this.findEndpoint(req, res);
            log.info((Object)("Endpoint: " + endpoint.describeEndpoint()));
            endpoint.service(req, res);
        }
        catch (UnsupportedOperationException ue) {
            ue.printStackTrace();
            this.sendError(res);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        finally {
            FlexContext.clearThreadLocalObjects();
        }
        log.info((Object)"=========== END FLEX REQUEST");
    }

    private void sendError(HttpServletResponse res) {
        if (!res.isCommitted()) {
            try {
                res.sendError(405);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Endpoint findEndpoint(HttpServletRequest req, HttpServletResponse res) {
        String contextPath = req.getContextPath();
        String pathInfo = req.getPathInfo();
        String endpointPath = req.getServletPath();
        if (pathInfo != null) {
            endpointPath = endpointPath + pathInfo;
        }
        log.info((Object)("flex request for cp=" + contextPath + " ep=" + endpointPath));
        try {
            return this.broker.getEndpoint(endpointPath, contextPath);
        }
        catch (MessageException me) {
            if (!res.isCommitted()) {
                try {
                    res.sendError(404);
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public void createThreadLocals() {
        MessageBroker.createThreadLocalObjects();
        FlexContext.createThreadLocalObjects();
        SerializationContext.createThreadLocalObjects();
        TypeMarshallingContext.createThreadLocalObjects();
    }

    protected void destroyThreadLocals() {
        MessageBroker.releaseThreadLocalObjects();
        FlexContext.releaseThreadLocalObjects();
        SerializationContext.releaseThreadLocalObjects();
        TypeMarshallingContext.releaseThreadLocalObjects();
    }

    private RemotingService createRemotingService() {
        RemotingService remotingService = null;
        remotingService = new RemotingService();
        remotingService.setId("remoting-service");
        this.broker.addService((Service)remotingService);
        log.info((Object)("Flex remotingservice not found- creating " + remotingService));
        return remotingService;
    }

    private RemotingService findRemotingService() {
        return (RemotingService)this.broker.getServiceByType(RemotingService.class.getName());
    }

    private void registerSeamAdapter(RemotingService remotingService) {
        if (remotingService.getRegisteredAdapters().get("seam-adapter") == null) {
            remotingService.registerAdapter("seam-adapter", SeamAdapter.class.getName());
        }
    }

    private Destination createDestination(String destinationName, String componentName) {
        RemotingService remotingService = this.findRemotingService();
        if (remotingService == null) {
            remotingService = this.createRemotingService();
        }
        RemotingDestination destination = (RemotingDestination)remotingService.createDestination(destinationName);
        destination.setFactory((FlexFactory)new FlexSeamFactory(destinationName, componentName));
        this.registerSeamAdapter(remotingService);
        destination.createAdapter("seam-adapter");
        destination.addChannel(SEAM_ENDPOINT);
        return destination;
    }

    public void addDestinations(Collection<Class<?>> destinations) {
        for (Class<?> annotatedClass : destinations) {
            log.info((Object)("Adding scanned flex desitionation for class " + annotatedClass));
            FlexRemote fr = annotatedClass.getAnnotation(FlexRemote.class);
            Name name = annotatedClass.getAnnotation(Name.class);
            String destinationName = fr.name();
            String componentName = name.value();
            Destination destination = this.createDestination(destinationName, componentName);
            destination.start();
        }
    }
}

