/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.guice;

import com.google.inject.Injector;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.ioc.guice.Guice;
import org.jboss.seam.ioc.guice.GuiceInit;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Interceptor
public class GuiceInterceptor {
    private static final Log log = Logging.getLog(GuiceInterceptor.class);
    private static final long serialVersionUID = -6716553117162905303L;
    private transient Injector defaultInjector = null;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        Injector injector = this.getInjectorForClass(invocationContext.getMethod().getDeclaringClass());
        if (log.isTraceEnabled()) {
            log.trace((Object)"Injecting members of: #0", new Object[]{invocationContext.getTarget().getClass().getName()});
        }
        injector.injectMembers(invocationContext.getTarget());
        return invocationContext.proceed();
    }

    private Injector getInjectorForClass(Class<?> declaringClass) {
        Guice guice = declaringClass.getAnnotation(Guice.class);
        String expr = guice != null ? guice.value() : null;
        return expr != null && expr.length() > 0 ? GuiceInterceptor.getInjectorByName(expr) : this.getCachedDefaultInjector();
    }

    private Injector getCachedDefaultInjector() {
        if (this.defaultInjector == null) {
            GuiceInit init = (GuiceInit)Component.getInstance(GuiceInit.class);
            if (init != null) {
                this.defaultInjector = init.getInjector();
            }
            if (this.defaultInjector == null) {
                throw new IllegalStateException("Default Guice injector not specified.");
            }
        }
        return this.defaultInjector;
    }

    public static Injector getInjectorByName(String expr) {
        Object result = expr.startsWith("#") ? Expressions.instance().createValueExpression(expr).getValue() : Component.getInstance((String)expr);
        if (!(result instanceof Injector)) {
            throw new IllegalArgumentException("Expression '" + expr + "' does not evaluate to a Guice injector.");
        }
        return (Injector)result;
    }
}

