/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.mail.ui.MailComponent;
import org.jboss.seam.ui.util.JSF;
import org.jboss.seam.util.FacesResources;
import org.jboss.seam.util.RandomStringUtils;
import org.jboss.seam.util.Reflections;

public class UIAttachment
extends MailComponent
implements ValueHolder {
    private Object value;
    private String contentType;
    private String fileName;
    private String status;
    private String disposition = "attachment";

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.getValue("value");
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getChildCount() > 0) {
            if (Reflections.isInstanceOf(((UIComponent)this.getChildren().get(0)).getClass(), (String)"org.jboss.seam.pdf.ui.UIDocument")) {
                Method method = Reflections.getSetterMethod(((UIComponent)this.getChildren().get(0)).getClass(), (String)"sendRedirect");
                Reflections.invokeAndWrap((Method)method, this.getChildren().get(0), (Object[])new Object[]{false});
                JSF.renderChildren((FacesContext)context, (UIComponent)this);
            } else {
                this.setValue(this.encode(context).getBytes());
                if (this.getContentType() == null) {
                    this.setContentType("text/html");
                }
            }
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        block17: {
            URLDataSource ds = null;
            try {
                if (this.getValue() instanceof URL) {
                    URL url = (URL)this.getValue();
                    ds = new URLDataSource(url);
                } else if (this.getValue() instanceof File) {
                    File file = (File)this.getValue();
                    ds = new FileDataSource(file);
                } else if (this.getValue() instanceof String) {
                    String string = (String)this.getValue();
                    ds = new URLDataSource(FacesResources.getResource((String)string, (ExternalContext)context.getExternalContext()));
                } else if (this.getValue() instanceof InputStream) {
                    InputStream is = (InputStream)this.getValue();
                    ds = new ByteArrayDataSource(is, this.getContentType());
                } else if (Reflections.isInstanceOf(this.getValue().getClass(), (String)"org.jboss.seam.pdf.DocumentData")) {
                    Method dataGetter = Reflections.getGetterMethod(this.getValue().getClass(), (String)"data");
                    Method docTypeGetter = Reflections.getGetterMethod(this.getValue().getClass(), (String)"docType");
                    Object docType = Reflections.invokeAndWrap((Method)docTypeGetter, (Object)this.getValue(), (Object[])new Object[0]);
                    Method mimeTypeGetter = Reflections.getGetterMethod(docType.getClass(), (String)"mimeType");
                    ds = new ByteArrayDataSource((byte[])Reflections.invokeAndWrap((Method)dataGetter, (Object)this.getValue(), (Object[])new Object[0]), (String)Reflections.invokeAndWrap((Method)mimeTypeGetter, (Object)docType, (Object[])new Object[0]));
                } else if (this.getValue() != null && this.getValue().getClass().isArray() && this.getValue().getClass().getComponentType().isAssignableFrom(Byte.TYPE)) {
                    byte[] b = (byte[])this.getValue();
                    ds = new ByteArrayDataSource(b, this.getContentType());
                }
                if (ds == null) break block17;
                try {
                    ds.getInputStream();
                }
                catch (Exception e) {
                    if (this.value != null) {
                        throw new NullPointerException("Error accessing " + this.value);
                    }
                    throw new NullPointerException("Error accessing " + this.getValueExpression("value").getExpressionString());
                }
                MimeBodyPart attachment = new MimeBodyPart();
                String contentId = RandomStringUtils.randomAlphabetic((int)20).toLowerCase();
                attachment.setContentID("<" + contentId + ">");
                attachment.setDataHandler(new DataHandler((DataSource)ds));
                attachment.setFileName(this.getName(ds.getName()));
                attachment.setDisposition(this.getDisposition());
                super.getRootMultipart().addBodyPart((BodyPart)attachment);
                if (this.getStatus() != null) {
                    AttachmentStatus attachmentStatus = new AttachmentStatus();
                    attachmentStatus.setContentId(contentId);
                    Contexts.getEventContext().set(this.getStatus(), (Object)attachmentStatus);
                }
            }
            catch (MessagingException e) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getContentType() {
        if (this.contentType == null) {
            return this.getString("contentType");
        }
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        if (this.fileName == null) {
            return this.getString("fileName");
        }
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private String removePath(String fileName) {
        if (fileName.lastIndexOf("/") > 0) {
            return fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        return fileName;
    }

    private String getName(String name) {
        if (this.getFileName() != null) {
            return this.getFileName();
        }
        return this.removePath(name);
    }

    public Converter getConverter() {
        return null;
    }

    public Object getLocalValue() {
        return this.value;
    }

    public void setConverter(Converter converter) {
        throw new UnsupportedOperationException("Cannot attach a converter to an attachment");
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        if ("attachment".equals(disposition) || "inline".equals(disposition)) {
            this.disposition = disposition;
        }
    }

    public class AttachmentStatus {
        private String contentId;

        public String getContentId() {
            return this.contentId;
        }

        public void setContentId(String contentId) {
            this.contentId = contentId;
        }
    }
}

