/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter2;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.core.Manager;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pdf.DocumentData;
import org.jboss.seam.pdf.DocumentStore;
import org.jboss.seam.pdf.ITextUtils;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UISignature;

public class UIDocument
extends ITextComponent {
    public static final String COMPONENT_TYPE = "org.jboss.seam.pdf.ui.UIDocument";
    DocWriter writer;
    Document document;
    ByteArrayOutputStream stream;
    String id;
    String baseName;
    DocumentData.DocType docType;
    String type;
    String title;
    String subject;
    String keywords;
    String author;
    String creator;
    String orientation;
    String pageSize;
    String margins;
    Boolean marginMirroring;
    boolean sendRedirect = true;
    UISignature signatureField;

    public void setType(String type) {
        this.type = type;
    }

    public void setMargins(String margins) {
        this.margins = margins;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public void setMarginMirroring(Boolean marginMirroring) {
        this.marginMirroring = marginMirroring;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public void setSendRedirect(boolean sendRedirect) {
        this.sendRedirect = sendRedirect;
    }

    public boolean getSendRedirect() {
        return this.sendRedirect;
    }

    public Object getITextObject() {
        return this.document;
    }

    public void createITextObject(FacesContext context) {
        this.type = (String)this.valueBinding(context, "type", this.type);
        this.docType = this.docTypeForName(this.type);
        this.document = new Document();
        this.pageSize = (String)this.valueBinding(context, "pageSize", this.pageSize);
        if (this.pageSize != null) {
            this.document.setPageSize(ITextUtils.pageSizeValue(this.pageSize));
        }
        this.orientation = (String)this.valueBinding(context, "orientation", this.orientation);
        if (this.orientation != null && !this.orientation.equalsIgnoreCase("portrait")) {
            if (this.orientation.equalsIgnoreCase("landscape")) {
                Rectangle currentSize = this.document.getPageSize();
                this.document.setPageSize(new Rectangle(currentSize.height(), currentSize.width()));
            } else {
                throw new RuntimeException("orientation value " + this.orientation + "unknown");
            }
        }
        this.margins = (String)this.valueBinding(context, "margins", this.margins);
        if (this.margins != null) {
            float[] vals = ITextUtils.stringToFloatArray(this.margins);
            if (vals.length != 4) {
                throw new RuntimeException("margins must contain 4 float values");
            }
            this.document.setMargins(vals[0], vals[1], vals[2], vals[3]);
        }
        this.marginMirroring = (Boolean)this.valueBinding(context, "marginMirroring", this.marginMirroring);
        if (this.marginMirroring != null) {
            this.document.setMarginMirroring(this.marginMirroring.booleanValue());
        }
    }

    private void initMetaData(FacesContext context) {
        this.title = (String)this.valueBinding(context, "title", this.title);
        if (this.title != null) {
            this.document.addTitle(this.title);
        }
        this.subject = (String)this.valueBinding(context, "subject", this.subject);
        if (this.subject != null) {
            this.document.addSubject(this.subject);
        }
        this.keywords = (String)this.valueBinding(context, "keywords", this.keywords);
        if (this.keywords != null) {
            this.document.addKeywords(this.keywords);
        }
        this.author = (String)this.valueBinding(context, "author", this.author);
        if (this.author != null) {
            this.document.addAuthor(this.author);
        }
        this.creator = (String)this.valueBinding(context, "creator", this.creator);
        if (this.creator != null) {
            this.document.addCreator(this.creator);
        }
    }

    public void removeITextObject() {
        this.document = null;
    }

    public void handleAdd(Object o) {
        if (o instanceof Element) {
            try {
                this.document.add((Element)o);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("cannot add " + o);
        }
    }

    public void addSignature(UISignature signatureField) {
        this.signatureField = signatureField;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.stream = new ByteArrayOutputStream();
        try {
            switch (this.docType) {
                case PDF: {
                    this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.stream);
                    break;
                }
                case RTF: {
                    this.writer = RtfWriter2.getInstance((Document)this.document, (OutputStream)this.stream);
                    break;
                }
                case HTML: {
                    this.writer = HtmlWriter.getInstance((Document)this.document, (OutputStream)this.stream);
                }
            }
            this.initMetaData(context);
            this.processHeaders();
            this.document.open();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        if (this.sendRedirect) {
            DocumentStore store = DocumentStore.instance();
            this.id = store.newId();
            ResponseWriter response = context.getResponseWriter();
            response.write("<!DOCTYPE composition PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\" >");
            response.startElement("html", (UIComponent)this);
            response.writeAttribute("xmlns", (Object)"http://www.w3.org/1999/xhtml", null);
            response.startElement("head", (UIComponent)this);
            response.startElement("meta", (UIComponent)this);
            response.writeAttribute("http-equiv", (Object)"Refresh", null);
            String viewId = Pages.getViewId((FacesContext)context);
            this.baseName = this.baseNameForViewId(viewId);
            String url = store.preferredUrlForContent(this.baseName, this.docType, this.id);
            url = Manager.instance().encodeConversationId(url, viewId);
            response.writeAttribute("content", (Object)("0; URL=" + url), null);
            response.endElement("meta");
            response.endElement("head");
            response.startElement("body", (UIComponent)this);
        }
    }

    private void processHeaders() {
        UIComponent facet = this.getFacet("header");
        if (facet == null) {
            return;
        }
        if (facet instanceof UIComponent) {
            try {
                this.encode(FacesContext.getCurrentInstance(), facet);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String baseNameForViewId(String viewId) {
        int pos = viewId.lastIndexOf("/");
        if (pos != -1) {
            viewId = viewId.substring(pos + 1);
        }
        if ((pos = viewId.lastIndexOf(".")) != -1) {
            viewId = viewId.substring(0, pos);
        }
        return viewId;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.document.close();
        byte[] bytes = this.stream.toByteArray();
        if (this.signatureField != null) {
            bytes = this.signatureField.sign(bytes);
        }
        DocumentData documentData = new DocumentData(this.baseName, this.docType, bytes);
        if (this.sendRedirect) {
            DocumentStore.instance().saveData(this.id, documentData);
            ResponseWriter response = context.getResponseWriter();
            response.endElement("body");
            response.endElement("html");
            this.removeITextObject();
            Manager.instance().beforeRedirect();
        } else {
            UIComponent parent = this.getParent();
            if (parent instanceof ValueHolder) {
                ValueHolder holder = (ValueHolder)parent;
                holder.setValue((Object)documentData);
            }
        }
    }

    public DocWriter getWriter() {
        return this.writer;
    }

    private DocumentData.DocType docTypeForName(String typeName) {
        if (typeName != null) {
            if (typeName.equalsIgnoreCase(DocumentData.DocType.PDF.name())) {
                return DocumentData.DocType.PDF;
            }
            if (typeName.equalsIgnoreCase(DocumentData.DocType.RTF.name())) {
                return DocumentData.DocType.RTF;
            }
            if (typeName.equalsIgnoreCase(DocumentData.DocType.HTML.name())) {
                return DocumentData.DocType.HTML;
            }
        }
        return DocumentData.DocType.PDF;
    }
}

