/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf;

public class DocumentData {
    byte[] data;
    DocumentType documentType;
    String baseName;
    String disposition = "inline";

    public DocumentData(String baseName, DocumentType documentType, byte[] data) {
        this.data = data;
        this.documentType = documentType;
        this.baseName = baseName;
    }

    public byte[] getData() {
        return this.data;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getFileName() {
        return this.getBaseName() + "." + this.getDocumentType().getExtension();
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public static class DocumentType {
        private String mimeType;
        private String extension;

        public DocumentType(String extension, String mimeType) {
            this.extension = extension;
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

