/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.remoting.CallContext;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;
import org.jboss.seam.util.EJB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call {
    private String id;
    private String componentName;
    private String methodName;
    private Throwable exception;
    private List<Wrapper> params = new ArrayList<Wrapper>();
    private Object result;
    private CallContext context;
    private List<String> constraints = null;

    public Call(String id, String componentName, String methodName) {
        this.id = id;
        this.componentName = componentName;
        this.methodName = methodName;
        this.context = new CallContext();
    }

    public CallContext getContext() {
        return this.context;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void addParameter(Wrapper param) {
        this.params.add(param);
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<String> constraints) {
        this.constraints = constraints;
    }

    public void execute() throws Exception {
        if (this.componentName != null) {
            this.processInvocation();
        }
    }

    private void processInvocation() throws Exception {
        Method m;
        Component component = Component.forName((String)this.componentName);
        if (component == null) {
            throw new RuntimeException("No such component: " + this.componentName);
        }
        Object instance = Component.getInstance((String)this.componentName, (boolean)true);
        if (instance == null) {
            throw new RuntimeException(String.format("Could not create instance of component %s", this.componentName));
        }
        Class type = null;
        if (component.getType().isSessionBean() && component.getBusinessInterfaces().size() > 0) {
            for (Class c : component.getBusinessInterfaces()) {
                if (!c.isAnnotationPresent(EJB.LOCAL)) continue;
                type = c;
                break;
            }
            if (type == null) {
                throw new RuntimeException(String.format("Type cannot be determined for component [%s]. Please ensure that it has a local interface.", component));
            }
        }
        if (type == null) {
            type = component.getBeanClass();
        }
        if ((m = this.findMethod(this.methodName, type)) == null) {
            throw new RuntimeException("No compatible method found.");
        }
        if (m.getAnnotation(WebRemote.class).exclude().length > 0) {
            this.constraints = Arrays.asList(m.getAnnotation(WebRemote.class).exclude());
        }
        Object[] params = this.convertParams(m.getGenericParameterTypes());
        try {
            this.result = m.invoke(instance, params);
        }
        catch (InvocationTargetException e) {
            this.exception = e.getCause();
        }
    }

    private Object[] convertParams(Type[] targetTypes) throws ConversionException {
        Object[] paramValues = new Object[targetTypes.length];
        int i = 0;
        while (i < targetTypes.length) {
            paramValues[i] = this.params.get(i).convert(targetTypes[i]);
            ++i;
        }
        return paramValues;
    }

    private Method findMethod(String name, Class cls) {
        HashMap<Method, Integer> candidates = new HashMap<Method, Integer>();
        Method[] methodArray = cls.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getAnnotation(WebRemote.class) != null && name.equals(m.getName()) && m.getParameterTypes().length == this.params.size()) {
                int score = 0;
                int i = 0;
                while (i < m.getParameterTypes().length) {
                    ConversionScore convScore = this.params.get(i).conversionScore(m.getParameterTypes()[i]);
                    if (convScore != ConversionScore.nomatch) {
                        score += convScore.getScore();
                    }
                    ++i;
                }
                candidates.put(m, score);
            }
            ++n2;
        }
        Method bestMethod = null;
        int bestScore = 0;
        for (Map.Entry entry : candidates.entrySet()) {
            int thisScore = (Integer)entry.getValue();
            if (bestMethod != null && thisScore <= bestScore) continue;
            bestMethod = (Method)entry.getKey();
            bestScore = thisScore;
        }
        return bestMethod;
    }
}

