/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.remoting.BaseRequestHandler;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.web.ServletContexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceGenerator
extends BaseRequestHandler
implements RequestHandler {
    private static final LogProvider log = Logging.getLogProvider(InterfaceGenerator.class);
    private static Map<Class, Set<String>> accessibleProperties = new HashMap<Class, Set<String>>();
    private Map<String, byte[]> interfaceCache = new HashMap<String, byte[]>();

    @Override
    public void handle(final HttpServletRequest request, final HttpServletResponse response) throws Exception {
        new ContextualHttpServletRequest(request){

            public void process() throws Exception {
                ServletContexts.instance().setRequest(request);
                if (request.getQueryString() == null) {
                    throw new ServletException("Invalid request - no component specified");
                }
                HashSet<Component> components = new HashSet<Component>();
                HashSet<Type> types = new HashSet<Type>();
                response.setContentType("text/javascript");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String componentName = ((String)e.nextElement()).trim();
                    Component component = Component.forName((String)componentName);
                    if (component == null) {
                        try {
                            Class c = Reflections.classForName((String)componentName);
                            InterfaceGenerator.this.appendClassSource((OutputStream)response.getOutputStream(), c, types);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)String.format("Component not found: [%s]", componentName));
                            throw new ServletException("Invalid request - component not found.");
                        }
                    }
                    components.add(component);
                }
                InterfaceGenerator.this.generateComponentInterface(components, (OutputStream)response.getOutputStream(), types);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateComponentInterface(Set<Component> components, OutputStream out, Set<Type> types) throws IOException {
        for (Component c : components) {
            if (c == null) continue;
            if (!this.interfaceCache.containsKey(c.getName())) {
                Map<String, byte[]> map = this.interfaceCache;
                synchronized (map) {
                    if (!this.interfaceCache.containsKey(c.getName())) {
                        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                        this.appendComponentSource(bOut, c, types);
                        this.interfaceCache.put(c.getName(), bOut.toByteArray());
                    }
                }
            }
            out.write(this.interfaceCache.get(c.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAccessibleProperties(Class cls) {
        if (cls.getName().contains("EnhancerByCGLIB")) {
            cls = cls.getSuperclass();
        }
        if (!accessibleProperties.containsKey(cls)) {
            Map<Class, Set<String>> map = accessibleProperties;
            synchronized (map) {
                if (!accessibleProperties.containsKey(cls)) {
                    HashSet<String> properties = new HashSet<String>();
                    Class c = cls;
                    while (c != null && !c.equals(Object.class)) {
                        AccessibleObject[] accessibleObjectArray = c.getDeclaredFields();
                        int n = accessibleObjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Field f = accessibleObjectArray[n2];
                            if (!Modifier.isTransient(f.getModifiers()) && !Modifier.isStatic(f.getModifiers())) {
                                String fieldName = String.valueOf(f.getName().substring(0, 1).toUpperCase()) + f.getName().substring(1);
                                String getterName = String.format("get%s", fieldName);
                                String setterName = String.format("set%s", fieldName);
                                Method getMethod = null;
                                Method setMethod = null;
                                try {
                                    getMethod = c.getMethod(getterName, new Class[0]);
                                }
                                catch (SecurityException securityException) {
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    getterName = String.format("is%s", fieldName);
                                    try {
                                        getMethod = c.getMethod(getterName, new Class[0]);
                                    }
                                    catch (NoSuchMethodException noSuchMethodException2) {}
                                }
                                try {
                                    setMethod = c.getMethod(setterName, f.getType());
                                }
                                catch (SecurityException securityException) {
                                }
                                catch (NoSuchMethodException noSuchMethodException) {}
                                if (Modifier.isPublic(f.getModifiers()) || getMethod != null && Modifier.isPublic(getMethod.getModifiers()) || setMethod != null && Modifier.isPublic(setMethod.getModifiers())) {
                                    properties.add(f.getName());
                                }
                            }
                            ++n2;
                        }
                        accessibleObjectArray = c.getDeclaredMethods();
                        n = accessibleObjectArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            block24: {
                                AccessibleObject m = accessibleObjectArray[n2];
                                if (((Method)m).getName().startsWith("get") || ((Method)m).getName().startsWith("is")) {
                                    int startIdx = ((Method)m).getName().startsWith("get") ? 3 : 2;
                                    try {
                                        c.getMethod(String.format("set%s", ((Method)m).getName().substring(startIdx)), ((Method)m).getReturnType());
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        break block24;
                                    }
                                    String propertyName = String.format("%s%s", Character.valueOf(Character.toLowerCase(((Method)m).getName().charAt(startIdx))), ((Method)m).getName().substring(startIdx + 1));
                                    if (!properties.contains(propertyName)) {
                                        properties.add(propertyName);
                                    }
                                }
                            }
                            ++n2;
                        }
                        c = c.getSuperclass();
                    }
                    accessibleProperties.put(cls, properties);
                }
            }
        }
        return accessibleProperties.get(cls);
    }

    private void appendComponentSource(OutputStream out, Component component, Set<Type> types) throws IOException {
        StringBuilder componentSrc = new StringBuilder();
        HashSet<Class> componentTypes = new HashSet<Class>();
        if (component.getType().isSessionBean() && component.getBusinessInterfaces().size() > 0) {
            for (Class c : component.getBusinessInterfaces()) {
                if (!c.isAnnotationPresent(EJB.LOCAL)) continue;
                componentTypes.add(c);
                break;
            }
            if (componentTypes.isEmpty()) {
                throw new RuntimeException(String.format("Type cannot be determined for component [%s]. Please ensure that it has a local interface.", component));
            }
        } else {
            if (component.getType().equals((Object)ComponentType.ENTITY_BEAN)) {
                this.appendTypeSource(out, component.getBeanClass(), types);
                return;
            }
            if (component.getType().equals((Object)ComponentType.JAVA_BEAN)) {
                Method[] methodArray = component.getBeanClass().getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getAnnotation(WebRemote.class) != null) {
                        componentTypes.add(component.getBeanClass());
                        break;
                    }
                    ++n2;
                }
                if (componentTypes.isEmpty()) {
                    this.appendTypeSource(out, component.getBeanClass(), types);
                    return;
                }
            } else {
                componentTypes.add(component.getBeanClass());
            }
        }
        boolean foundNew = false;
        for (Class type : componentTypes) {
            if (types.contains(type)) continue;
            foundNew = true;
            break;
        }
        if (!foundNew) {
            return;
        }
        if (component.getName().contains(".")) {
            componentSrc.append("Seam.Remoting.createNamespace('");
            componentSrc.append(component.getName().substring(0, component.getName().lastIndexOf(46)));
            componentSrc.append("');\n");
        }
        componentSrc.append("Seam.Remoting.type.");
        componentSrc.append(component.getName());
        componentSrc.append(" = function() {\n");
        componentSrc.append("  this.__callback = new Object();\n");
        for (Class type : componentTypes) {
            if (types.contains(type)) break;
            types.add(type);
            Method[] methodArray = type.getDeclaredMethods();
            int n = methodArray.length;
            int n3 = 0;
            while (n3 < n) {
                Method m = methodArray[n3];
                if (m.getAnnotation(WebRemote.class) != null) {
                    this.appendTypeSource(out, m.getGenericReturnType(), types);
                    componentSrc.append("  Seam.Remoting.type.");
                    componentSrc.append(component.getName());
                    componentSrc.append(".prototype.");
                    componentSrc.append(m.getName());
                    componentSrc.append(" = function(");
                    int i = 0;
                    while (i < m.getGenericParameterTypes().length) {
                        this.appendTypeSource(out, m.getGenericParameterTypes()[i], types);
                        if (i > 0) {
                            componentSrc.append(", ");
                        }
                        componentSrc.append("p");
                        componentSrc.append(i);
                        ++i;
                    }
                    if (m.getGenericParameterTypes().length > 0) {
                        componentSrc.append(", ");
                    }
                    componentSrc.append("callback, exceptionHandler) {\n");
                    componentSrc.append("    return Seam.Remoting.execute(this, \"");
                    componentSrc.append(m.getName());
                    componentSrc.append("\", [");
                    i = 0;
                    while (i < m.getParameterTypes().length) {
                        if (i > 0) {
                            componentSrc.append(", ");
                        }
                        componentSrc.append("p");
                        componentSrc.append(i);
                        ++i;
                    }
                    componentSrc.append("], callback, exceptionHandler);\n");
                    componentSrc.append("  }\n");
                }
                ++n3;
            }
            componentSrc.append("}\n");
            componentSrc.append("Seam.Remoting.type.");
            componentSrc.append(component.getName());
            componentSrc.append(".__name = \"");
            componentSrc.append(component.getName());
            componentSrc.append("\";\n\n");
            componentSrc.append("Seam.Component.register(Seam.Remoting.type.");
            componentSrc.append(component.getName());
            componentSrc.append(");\n\n");
            out.write(componentSrc.toString().getBytes());
        }
    }

    private void appendTypeSource(OutputStream out, Type type, Set<Type> types) throws IOException {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (classType.isArray()) {
                this.appendTypeSource(out, classType.getComponentType(), types);
                return;
            }
            if (classType.getName().startsWith("java.") || types.contains(type) || classType.isPrimitive()) {
                return;
            }
            types.add(type);
            this.appendClassSource(out, classType, types);
        } else if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                this.appendTypeSource(out, t, types);
                ++n2;
            }
        }
    }

    private void appendClassSource(OutputStream out, Class classType, Set<Type> types) throws IOException {
        if (classType.isEnum()) {
            return;
        }
        StringBuilder typeSource = new StringBuilder();
        String componentName = Seam.getComponentName((Class)classType);
        if (componentName == null) {
            componentName = classType.getName();
        }
        String typeName = componentName.replace('.', '$');
        typeSource.append("Seam.Remoting.type.");
        typeSource.append(typeName);
        typeSource.append(" = function() {\n");
        StringBuilder fields = new StringBuilder();
        StringBuilder accessors = new StringBuilder();
        StringBuilder mutators = new StringBuilder();
        HashMap<String, String> metadata = new HashMap<String, String>();
        String getMethodName = null;
        String setMethodName = null;
        for (String propertyName : InterfaceGenerator.getAccessibleProperties(classType)) {
            Type propertyType = null;
            Field f = null;
            try {
                f = classType.getDeclaredField(propertyName);
                propertyType = f.getGenericType();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                setMethodName = String.format("set%s%s", Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1));
                try {
                    getMethodName = String.format("get%s%s", Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1));
                    propertyType = classType.getMethod(getMethodName, new Class[0]).getGenericReturnType();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        getMethodName = String.format("is%s%s", Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1));
                        propertyType = classType.getMethod(getMethodName, new Class[0]).getGenericReturnType();
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        continue;
                    }
                }
            }
            this.appendTypeSource(out, propertyType, types);
            if (propertyType instanceof ParameterizedType) {
                Type[] typeArray = ((ParameterizedType)propertyType).getActualTypeArguments();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type t = typeArray[n2];
                    if (t instanceof Class) {
                        this.appendTypeSource(out, t, types);
                    }
                    ++n2;
                }
            }
            if (f != null) {
                String fieldName = String.valueOf(propertyName.substring(0, 1).toUpperCase()) + propertyName.substring(1);
                String getterName = String.format("get%s", fieldName);
                String setterName = String.format("set%s", fieldName);
                try {
                    classType.getMethod(getterName, new Class[0]);
                    getMethodName = getterName;
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    getterName = String.format("is%s", fieldName);
                    try {
                        if (Modifier.isPublic(classType.getMethod(getterName, new Class[0]).getModifiers())) {
                            getMethodName = getterName;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {}
                }
                try {
                    if (Modifier.isPublic(classType.getMethod(setterName, f.getType()).getModifiers())) {
                        setMethodName = setterName;
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (getMethodName == null && setMethodName == null) continue;
            metadata.put(propertyName, this.getFieldType(propertyType));
            fields.append("  this.");
            fields.append(propertyName);
            fields.append(" = undefined;\n");
            if (getMethodName != null) {
                accessors.append("  Seam.Remoting.type.");
                accessors.append(typeName);
                accessors.append(".prototype.");
                accessors.append(getMethodName);
                accessors.append(" = function() { return this.");
                accessors.append(propertyName);
                accessors.append("; }\n");
            }
            if (setMethodName == null) continue;
            mutators.append("  Seam.Remoting.type.");
            mutators.append(typeName);
            mutators.append(".prototype.");
            mutators.append(setMethodName);
            mutators.append(" = function(");
            mutators.append(propertyName);
            mutators.append(") { this.");
            mutators.append(propertyName);
            mutators.append(" = ");
            mutators.append(propertyName);
            mutators.append("; }\n");
        }
        typeSource.append((CharSequence)fields);
        typeSource.append((CharSequence)accessors);
        typeSource.append((CharSequence)mutators);
        typeSource.append("}\n\n");
        typeSource.append("Seam.Remoting.type.");
        typeSource.append(typeName);
        typeSource.append(".__name = \"");
        typeSource.append(componentName);
        typeSource.append("\";\n");
        typeSource.append("Seam.Remoting.type.");
        typeSource.append(typeName);
        typeSource.append(".__metadata = [\n");
        boolean first = true;
        for (String key : metadata.keySet()) {
            if (!first) {
                typeSource.append(",\n");
            }
            typeSource.append("  {field: \"");
            typeSource.append(key);
            typeSource.append("\", type: \"");
            typeSource.append((String)metadata.get(key));
            typeSource.append("\"}");
            first = false;
        }
        typeSource.append("];\n\n");
        if (classType.isAnnotationPresent(Name.class)) {
            typeSource.append("Seam.Component.register(Seam.Remoting.type.");
        } else {
            typeSource.append("Seam.Remoting.registerType(Seam.Remoting.type.");
        }
        typeSource.append(typeName);
        typeSource.append(");\n\n");
        out.write(typeSource.toString().getBytes());
    }

    protected String getFieldType(Type type) {
        if (type.equals(String.class) || type instanceof Class && ((Class)type).isEnum() || type.equals(BigInteger.class) || type.equals(BigDecimal.class)) {
            return "str";
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return "number";
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (Date.class.isAssignableFrom(cls) || Calendar.class.isAssignableFrom(cls)) {
                return "date";
            }
            if (cls.isArray()) {
                return "bag";
            }
            if (cls.isAssignableFrom(Map.class)) {
                return "map";
            }
            if (cls.isAssignableFrom(Collection.class)) {
                return "bag";
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            if (pt.getRawType() instanceof Class && Map.class.isAssignableFrom((Class)pt.getRawType())) {
                return "map";
            }
            if (pt.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)pt.getRawType())) {
                return "bag";
            }
        }
        return "bean";
    }
}

