/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletRequest;
import org.jboss.seam.ui.component.UIFileUpload;
import org.jboss.seam.ui.util.HTML;
import org.jboss.seam.ui.util.cdk.RendererBase;
import org.jboss.seam.web.MultipartRequest;

public class FileUploadRendererBase
extends RendererBase {
    protected Class getComponentClass() {
        return UIFileUpload.class;
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIFileUpload fileUpload = (UIFileUpload)component;
        writer.startElement("input", (UIComponent)fileUpload);
        writer.writeAttribute("type", (Object)"file", null);
        String clientId = fileUpload.getClientId(context);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        HTML.renderHTMLAttributes(writer, component, HTML.INPUT_FILE_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        writer.endElement("input");
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        UIFileUpload fileUpload = (UIFileUpload)component;
        ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
        if (!(request instanceof MultipartRequest)) {
            request = FileUploadRendererBase.unwrapMultipartRequest(request);
        }
        if (request instanceof MultipartRequest) {
            MultipartRequest multipartRequest = (MultipartRequest)request;
            String clientId = component.getClientId(context);
            fileUpload.setLocalInputStream(multipartRequest.getFileInputStream(clientId));
            fileUpload.setLocalContentType(multipartRequest.getFileContentType(clientId));
            fileUpload.setLocalFileName(multipartRequest.getFileName(clientId));
            fileUpload.setLocalFileSize(multipartRequest.getFileSize(clientId));
        }
    }

    private static ServletRequest unwrapMultipartRequest(ServletRequest request) {
        while (!(request instanceof MultipartRequest)) {
            boolean found = false;
            for (Method method : request.getClass().getMethods()) {
                if (!ServletRequest.class.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
                try {
                    request = (ServletRequest)method.invoke((Object)request, new Object[0]);
                    found = true;
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!found) {
                for (AccessibleObject accessibleObject : request.getClass().getDeclaredFields()) {
                    if (!ServletRequest.class.isAssignableFrom(((Field)accessibleObject).getType())) continue;
                    try {
                        request = (ServletRequest)((Field)accessibleObject).get(request);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (found) continue;
            break;
        }
        return request;
    }
}

