/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.util.cdk;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.jboss.seam.ui.util.cdk.RendererUtils;

public abstract class RendererBase
extends Renderer {
    protected static final String JAVASCRIPT_NAMESPACE = "JBossSeam";
    private static final RendererUtils utils = new RendererUtils();

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException("Context must not be null");
        }
        if (component == null) {
            throw new NullPointerException("Component must not be null");
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException("Component must be of type " + this.getComponentClass().getName());
        }
        this.preDecode(context, component);
        if (component.isRendered()) {
            this.doDecode(context, component);
        }
    }

    protected void preDecode(FacesContext context, UIComponent component) {
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("Context must not be null");
        }
        if (component == null) {
            throw new NullPointerException("Component must not be null");
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException("Component must be of type " + this.getComponentClass().getName());
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeBegin(writer, context, component);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("Context must not be null");
        }
        if (component == null) {
            throw new NullPointerException("Component must not be null");
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException("Component must be of type " + this.getComponentClass().getName());
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeChildren(writer, context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("Context must not be null");
        }
        if (component == null) {
            throw new NullPointerException("Component must not be null");
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException("Component must be of type " + this.getComponentClass().getName());
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeEnd(writer, context, component);
        }
    }

    protected abstract Class getComponentClass();

    protected void doDecode(FacesContext context, UIComponent component) {
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    public void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.renderChild(facesContext, child);
            }
        }
    }

    public void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static RendererUtils getUtils() {
        return utils;
    }
}

