/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket;

import org.apache.wicket.IRedirectListener;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.markup.html.form.IFormSubmitListener;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.link.ILinkListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequestCycleProcessor;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.web.Session;
import org.jboss.seam.wicket.SeamAuthorizationStrategy;
import org.jboss.seam.wicket.SeamComponentInstantiationListener;
import org.jboss.seam.wicket.international.SeamStatusMessagesListener;

public abstract class SeamWebApplication
extends WebApplication {
    public org.apache.wicket.Session newSession(Request request, Response response) {
        return new WebSession(request){

            public void invalidate() {
                Session.getInstance().invalidate();
            }

            public void invalidateNow() {
                Session.getInstance().invalidate();
            }
        };
    }

    protected IRequestCycleProcessor newRequestCycleProcessor() {
        return new WebRequestCycleProcessor(){

            protected IRequestCodingStrategy newRequestCodingStrategy() {
                return new WebRequestCodingStrategy(){

                    protected CharSequence encode(RequestCycle requestCycle, IListenerInterfaceRequestTarget requestTarget) {
                        String name = requestTarget.getRequestListenerInterface().getName();
                        CharSequence url = super.encode(requestCycle, requestTarget);
                        if (Manager.instance().isReallyLongRunningConversation() && (IFormSubmitListener.INTERFACE.getName().equals(name) || ILinkListener.INTERFACE.getName().equals(name) || IBehaviorListener.INTERFACE.getName().equals(name) || IOnChangeListener.INTERFACE.getName().equals(name) || IRedirectListener.INTERFACE.getName().equals(name))) {
                            StringBuilder stringBuilder = new StringBuilder(url);
                            stringBuilder.append("&" + Manager.instance().getConversationIdParameter() + "=" + Conversation.instance().getId());
                            url = stringBuilder.subSequence(0, stringBuilder.length());
                        }
                        return url;
                    }

                    protected CharSequence encode(RequestCycle requestCycle, IBookmarkablePageRequestTarget requestTarget) {
                        StringBuilder stringBuilder = new StringBuilder(super.encode(requestCycle, requestTarget));
                        if (Manager.instance().isLongRunningConversation()) {
                            stringBuilder.append("&" + Manager.instance().getConversationIdParameter() + "=" + Conversation.instance().getId());
                        }
                        return stringBuilder.subSequence(0, stringBuilder.length());
                    }
                };
            }
        };
    }

    protected void init() {
        super.init();
        this.inititializeSeamSecurity();
        this.initializeSeamStatusMessages();
        this.addComponentInstantiationListener(new SeamComponentInstantiationListener());
    }

    protected void inititializeSeamSecurity() {
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new SeamAuthorizationStrategy(this.getLoginPage()));
    }

    protected void initializeSeamStatusMessages() {
        this.addComponentOnBeforeRenderListener(new SeamStatusMessagesListener());
    }

    protected abstract Class getLoginPage();
}

