/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Page;
import org.apache.wicket.util.string.Strings;
import org.jboss.seam.Component;
import org.jboss.seam.Namespace;
import org.jboss.seam.RequiredException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.RaiseEvent;
import org.jboss.seam.annotations.bpm.BeginTask;
import org.jboss.seam.annotations.bpm.EndTask;
import org.jboss.seam.annotations.bpm.StartTask;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.annotations.security.RoleCheck;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.wicket.annotations.NoConversationPage;
import org.jboss.seam.wicket.ioc.BijectedAttribute;
import org.jboss.seam.wicket.ioc.BijectedField;
import org.jboss.seam.wicket.ioc.BijectedMethod;
import org.jboss.seam.wicket.ioc.BijectionInterceptor;
import org.jboss.seam.wicket.ioc.ConversationInterceptor;
import org.jboss.seam.wicket.ioc.EventInterceptor;
import org.jboss.seam.wicket.ioc.InjectedField;
import org.jboss.seam.wicket.ioc.StatelessInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketComponent<T> {
    private static LogProvider log = Logging.getLogProvider(WicketComponent.class);
    private Class<? extends T> type;
    private Class<?> enclosingType;
    private String enclosingInstanceVariableName;
    private List<BijectedAttribute<In>> inAttributes = new ArrayList<BijectedAttribute<In>>();
    private List<BijectedAttribute<Out>> outAttributes = new ArrayList<BijectedAttribute<Out>>();
    private List<InjectedLogger> loggerFields = new ArrayList<InjectedLogger>();
    private Set<AccessibleObject> conversationManagementMembers = new HashSet<AccessibleObject>();
    private List<StatelessInterceptor<T>> interceptors = new ArrayList<StatelessInterceptor<T>>();
    private Set<String> restrictions;
    boolean anyMethodHasRaiseEvent = false;
    private Class<? extends Page> noConversationPage;

    public Class<?> getType() {
        return this.type;
    }

    public static <T> WicketComponent<T> getInstance(Class<? extends T> type) {
        String name = WicketComponent.getContextVariableName(type);
        if (Contexts.getApplicationContext().isSet(name)) {
            return (WicketComponent)Contexts.getApplicationContext().get(name);
        }
        return null;
    }

    private void initInterceptors() {
        this.interceptors.add(new BijectionInterceptor());
        if (!this.conversationManagementMembers.isEmpty()) {
            this.interceptors.add(new ConversationInterceptor());
        }
        if (this.anyMethodHasRaiseEvent) {
            this.interceptors.add(new EventInterceptor());
        }
    }

    public List<StatelessInterceptor<T>> getInterceptors() {
        return this.interceptors;
    }

    public static String getContextVariableName(Class<?> type) {
        return type.getName() + ".wicketComponent";
    }

    public String getName() {
        return WicketComponent.getContextVariableName(this.type);
    }

    public WicketComponent(Class<? extends T> type) {
        this.type = type;
        this.enclosingType = type.getEnclosingClass();
        if (this.enclosingType != null) {
            log.info((Object)("Class: " + type + ", enclosed by " + this.enclosingType));
        } else {
            log.info((Object)("Class: " + type));
        }
        this.scan();
        this.initInterceptors();
        Contexts.getApplicationContext().set(this.getName(), (Object)this);
    }

    private void scan() {
        Class<T> clazz = this.type;
        this.scanClassEnclosureHierachy();
        for (Method method : clazz.getDeclaredMethods()) {
            this.add(method);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            this.add((Field)accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredConstructors()) {
            this.add((Constructor<T>)accessibleObject);
        }
    }

    private void scanClassEnclosureHierachy() {
        Class<Object> cls = this.type;
        int i = 0;
        while (cls != null) {
            for (Annotation annotation : cls.getAnnotations()) {
                if (annotation instanceof Restrict) {
                    Restrict restrict = (Restrict)annotation;
                    if (this.restrictions == null) {
                        this.restrictions = new HashSet<String>();
                    }
                    if (Strings.isEmpty((CharSequence)restrict.value())) {
                        throw new IllegalStateException("@Restrict on " + cls.getName() + " must specify an expression");
                    }
                    this.restrictions.add(restrict.value());
                }
                if (annotation.annotationType().isAnnotationPresent(RoleCheck.class)) {
                    if (this.restrictions == null) {
                        this.restrictions = new HashSet<String>();
                    }
                    this.restrictions.add("#{identity.hasRole('" + annotation.annotationType().getSimpleName().toLowerCase() + "')}");
                }
                if (!(annotation instanceof NoConversationPage)) continue;
                NoConversationPage noConversationPage = (NoConversationPage)annotation;
                this.noConversationPage = noConversationPage.value();
            }
            cls = cls.getEnclosingClass();
            ++i;
        }
        if (i > 1) {
            this.enclosingInstanceVariableName = "this$" + (i - 2);
        }
    }

    public void checkRestrictions() {
        if (Identity.isSecurityEnabled() && this.restrictions != null) {
            for (String restriction : this.restrictions) {
                Identity.instance().checkRestriction(restriction);
            }
        }
    }

    public void outject(T target) {
        for (BijectedAttribute<Out> out : this.outAttributes) {
            ScopeType outScope;
            Object value = out.get(target);
            if (value == null && ((Out)out.getAnnotation()).required()) {
                throw new RequiredException("@Out attribute requires non-null value: " + out.toString());
            }
            Component component = null;
            if (((Out)out.getAnnotation()).scope() == ScopeType.UNSPECIFIED) {
                component = Component.forName((String)out.getContextVariableName());
                if (value != null && component != null && !component.isInstance(value)) {
                    throw new IllegalArgumentException("attempted to bind an @Out attribute of the wrong type to: " + out.toString());
                }
            } else if (((Out)out.getAnnotation()).scope() == ScopeType.STATELESS) {
                throw new IllegalArgumentException("cannot specify explicit scope=STATELESS on @Out: " + out.toString());
            }
            ScopeType scopeType = outScope = component == null ? ((Out)out.getAnnotation()).scope() : component.getScope();
            if (outScope == null) {
                throw new IllegalArgumentException("cannot determine scope to outject to on @Out: " + out.toString());
            }
            if (!outScope.isContextActive()) continue;
            if (value == null) {
                outScope.getContext().remove(out.getContextVariableName());
                continue;
            }
            outScope.getContext().set(out.getContextVariableName(), value);
        }
    }

    public void disinject(T target) {
        for (BijectedAttribute<In> in : this.inAttributes) {
            if (in.getType().isPrimitive()) continue;
            in.set(target, null);
        }
    }

    public void inject(T instance) {
        for (BijectedAttribute<In> in : this.inAttributes) {
            in.set(instance, WicketComponent.getValue(in, instance));
        }
    }

    private void add(Constructor<T> constructor) {
        if (constructor.isAnnotationPresent(Begin.class) || constructor.isAnnotationPresent(End.class) || constructor.isAnnotationPresent(StartTask.class) || constructor.isAnnotationPresent(BeginTask.class) || constructor.isAnnotationPresent(EndTask.class)) {
            this.conversationManagementMembers.add(constructor);
        }
    }

    private void add(Method method) {
        if (method.isAnnotationPresent(In.class)) {
            final In in = method.getAnnotation(In.class);
            this.inAttributes.add(new BijectedMethod(method, (Annotation)in){

                protected String getSpecifiedContextVariableName() {
                    return in.value();
                }
            });
        }
        if (method.isAnnotationPresent(Out.class)) {
            final Out out = method.getAnnotation(Out.class);
            this.outAttributes.add(new BijectedMethod(method, (Annotation)out){

                protected String getSpecifiedContextVariableName() {
                    return out.value();
                }
            });
        }
        if (method.isAnnotationPresent(Begin.class) || method.isAnnotationPresent(End.class) || method.isAnnotationPresent(StartTask.class) || method.isAnnotationPresent(BeginTask.class) || method.isAnnotationPresent(EndTask.class)) {
            this.conversationManagementMembers.add(method);
        }
        if (method.isAnnotationPresent(RaiseEvent.class)) {
            this.anyMethodHasRaiseEvent = true;
        }
    }

    private void add(Field field) {
        if (field.isAnnotationPresent(In.class)) {
            final In in = field.getAnnotation(In.class);
            this.inAttributes.add(new BijectedField(field, (Annotation)in){

                protected String getSpecifiedContextVariableName() {
                    return in.value();
                }
            });
        }
        if (field.isAnnotationPresent(Out.class)) {
            final Out out = field.getAnnotation(Out.class);
            this.outAttributes.add(new BijectedField(field, (Annotation)out){

                protected String getSpecifiedContextVariableName() {
                    return out.value();
                }
            });
        }
        if (field.isAnnotationPresent(Logger.class)) {
            Logger logger = field.getAnnotation(Logger.class);
            InjectedLogger loggerField = new InjectedLogger(field, logger);
            if (Modifier.isStatic(field.getModifiers())) {
                loggerField.set(null);
            } else {
                this.loggerFields.add(loggerField);
            }
        }
    }

    private static Object getValue(BijectedAttribute<In> in, Object bean) {
        String name = in.getContextVariableName();
        if (name.startsWith("#")) {
            if (log.isDebugEnabled()) {
                log.trace((Object)("trying to inject with EL expression: " + name));
            }
            return Expressions.instance().createValueExpression(name).getValue();
        }
        if (((In)in.getAnnotation()).scope() == ScopeType.UNSPECIFIED) {
            if (log.isDebugEnabled()) {
                log.trace((Object)("trying to inject with hierarchical context search: " + name));
            }
            return WicketComponent.getInstanceInAllNamespaces(name, ((In)in.getAnnotation()).create());
        }
        if (((In)in.getAnnotation()).create()) {
            throw new IllegalArgumentException("cannot combine create=true with explicit scope on @In: " + in.toString());
        }
        if (((In)in.getAnnotation()).scope() == ScopeType.STATELESS) {
            throw new IllegalArgumentException("cannot specify explicit scope=STATELESS on @In: " + in.toString());
        }
        log.trace((Object)("trying to inject from specified context: " + name));
        if (((In)in.getAnnotation()).scope().isContextActive()) {
            return ((In)in.getAnnotation()).scope().getContext().get(name);
        }
        return null;
    }

    private static Object getInstanceInAllNamespaces(String name, boolean create) {
        Object result;
        block1: {
            Namespace namespace;
            result = Component.getInstance((String)name, (boolean)create);
            if (result != null) break block1;
            Iterator i$ = Init.instance().getGlobalImports().iterator();
            while (i$.hasNext() && (result = (namespace = (Namespace)i$.next()).getComponentInstance(name, create)) == null) {
            }
        }
        return result;
    }

    public void initialize(T bean) {
        this.injectLog(bean);
    }

    private void injectLog(T bean) {
        for (InjectedLogger injectedLogger : this.loggerFields) {
            injectedLogger.set(bean);
        }
    }

    public Class<?> getEnclosingType() {
        return this.enclosingType;
    }

    public String getEnclosingInstanceVariableName() {
        return this.enclosingInstanceVariableName;
    }

    public String toString() {
        return "WicketComponent(" + this.type + ")";
    }

    public boolean isConversationManagementMethod(AccessibleObject member) {
        return member != null && this.conversationManagementMembers.contains(member);
    }

    public Class<? extends Page> getNoConversationPage() {
        return this.noConversationPage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InjectedLogger
    extends InjectedField<Logger> {
        private Log logInstance;

        InjectedLogger(Field field, Logger annotation) {
            super(field, annotation);
            String category = ((Logger)this.getAnnotation()).value();
            this.logInstance = "".equals(category) ? Logging.getLog((Class)this.getType()) : Logging.getLog((String)category);
        }

        Log getLogInstance() {
            return this.logInstance;
        }

        public void set(Object bean) {
            super.set(bean, this.logInstance);
        }
    }
}

