/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import javax.servlet.ServletContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.wicket.WicketComponent;
import org.jboss.seam.wicket.ioc.InstrumentedComponent;
import org.jboss.seam.wicket.ioc.WicketClassLoader;
import org.jboss.seam.wicket.ioc.WicketHandler;

public class JavassistInstrumentor {
    private static LogProvider log = Logging.getLogProvider(JavassistInstrumentor.class);
    public static String DEFAULT_WICKET_COMPONENT_DIRECTORY_PATH = "WEB-INF/wicket";
    private ClassLoader classLoader;
    private final List<String> classes = new ArrayList<String>();
    private File wicketComponentDirectory;
    private ClassPool classPool = new ClassPool();

    public JavassistInstrumentor(ServletContext servletContext) {
        this.wicketComponentDirectory = JavassistInstrumentor.getWicketComponentDirectory(servletContext);
    }

    public void instrument() throws NotFoundException, CannotCompileException, ClassNotFoundException {
        if (this.wicketComponentDirectory == null) {
            log.warn((Object)"No wicket components found to give Seam super powers to");
            this.classLoader = Thread.currentThread().getContextClassLoader();
            return;
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        this.classPool = new ClassPool();
        this.classLoader = new WicketClassLoader(parent, this.classPool, this.classes, this.wicketComponentDirectory);
        this.classPool.insertClassPath(this.wicketComponentDirectory.getAbsolutePath());
        this.classPool.insertClassPath((ClassPath)new LoaderClassPath(parent));
        if (this.wicketComponentDirectory.exists()) {
            this.handleDirectory(this.wicketComponentDirectory, null);
        }
        for (String className : this.classes) {
            Class<?> clazz = this.classLoader.loadClass(className);
            new WicketComponent(clazz);
        }
    }

    private static File getWicketComponentDirectory(ServletContext servletContext) {
        String path = servletContext.getRealPath(DEFAULT_WICKET_COMPONENT_DIRECTORY_PATH);
        if (path == null) {
            log.debug((Object)("Could not find path for " + DEFAULT_WICKET_COMPONENT_DIRECTORY_PATH));
        } else {
            File wicketComponentDir = new File(path);
            if (wicketComponentDir.exists()) {
                return wicketComponentDir;
            }
        }
        return null;
    }

    private void handleDirectory(File file, String path) throws NotFoundException, CannotCompileException {
        log.debug((Object)("directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this.handleItem(newPath);
        }
    }

    private void handleItem(String path) throws NotFoundException, CannotCompileException {
        if (path.endsWith(".class")) {
            String className = JavassistInstrumentor.filenameToClassname(path);
            this.instrumentClass(className, this.classPool);
        }
    }

    protected static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    private void instrumentClass(String className, ClassPool classPool) throws NotFoundException, CannotCompileException {
        log.debug((Object)("Instrumenting " + className));
        CtClass implementation = classPool.get(className);
        if (JavassistInstrumentor.isInstrumentable(implementation)) {
            CtClass handlerClass = classPool.get(WicketHandler.class.getName());
            CtField handlerField = new CtField(handlerClass, "handler", implementation);
            CtField.Initializer handlerInitializer = CtField.Initializer.byCall((CtClass)handlerClass, (String)"create");
            implementation.addField(handlerField, handlerInitializer);
            CtClass exception = classPool.get(Exception.class.getName());
            CtClass instrumentedComponent = classPool.get(InstrumentedComponent.class.getName());
            implementation.addInterface(instrumentedComponent);
            CtMethod getHandlerMethod = CtNewMethod.getter((String)"getHandler", (CtField)handlerField);
            CtMethod getEnclosingInstance = CtNewMethod.make((String)("public " + InstrumentedComponent.class.getName() + " getEnclosingInstance() { return handler.getEnclosingInstance(this); }"), (CtClass)implementation);
            implementation.addMethod(getEnclosingInstance);
            implementation.addMethod(getHandlerMethod);
            for (CtMethod ctMethod : implementation.getDeclaredMethods()) {
                if (Modifier.isStatic((int)ctMethod.getModifiers()) || "getHandler".equals(ctMethod.getName()) || "getEnclosingInstance".equals(ctMethod.getName())) continue;
                String newName = implementation.makeUniqueName(ctMethod.getName());
                CtMethod newMethod = CtNewMethod.copy((CtMethod)ctMethod, (String)newName, (CtClass)implementation, null);
                implementation.addMethod(newMethod);
                ctMethod.setBody(JavassistInstrumentor.createBody(implementation, ctMethod, newMethod));
                log.trace((Object)("instrumented method " + ctMethod.getName()));
            }
            for (CtMethod ctMethod : implementation.getConstructors()) {
                if (!ctMethod.isConstructor()) continue;
                String constructorObject = JavassistInstrumentor.createConstructorObject((CtConstructor)ctMethod);
                ctMethod.insertBeforeBody(constructorObject + "handler.beforeInvoke(this, constructor);");
                ctMethod.addCatch("{" + constructorObject + "throw new RuntimeException(handler.handleException(this, constructor, e));}", exception, "e");
                ctMethod.insertAfter(constructorObject + "handler.afterInvoke(this, constructor);");
                log.trace((Object)("instrumented constructor " + ctMethod.getName()));
            }
        }
        this.classes.add(implementation.getName());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static String createBody(CtClass clazz, CtMethod method, CtMethod newMethod) throws NotFoundException {
        String src = "{" + JavassistInstrumentor.createMethodObject(method) + "handler.beforeInvoke(this, method);" + JavassistInstrumentor.createMethodDelegation(newMethod) + "return ($r) handler.afterInvoke(this, method, ($w) result);}";
        log.trace((Object)("Creating method " + clazz.getName() + "." + newMethod.getName() + "(" + newMethod.getSignature() + ")" + src));
        return src;
    }

    private static String createMethodDelegation(CtMethod method) throws NotFoundException {
        CtClass returnType = method.getReturnType();
        if (returnType.equals(CtClass.voidType)) {
            return "Object result = null; " + JavassistInstrumentor.wrapInExceptionHandler(method.getName() + "($$);");
        }
        String src = returnType.getName() + " result;";
        src = src + JavassistInstrumentor.wrapInExceptionHandler("result = " + method.getName() + "($$);");
        return src;
    }

    private static String wrapInExceptionHandler(String src) {
        return "try {" + src + "} catch (Exception e) { throw new RuntimeException(handler.handleException(this, method, e)); }";
    }

    private static String createParameterTypesArray(CtBehavior behavior) throws NotFoundException {
        String src = "Class[] parameterTypes = new Class[" + behavior.getParameterTypes().length + "];";
        for (int i = 0; i < behavior.getParameterTypes().length; ++i) {
            src = src + "parameterTypes[" + i + "] = " + behavior.getParameterTypes()[i].getName() + ".class;";
        }
        return src;
    }

    private static String createMethodObject(CtMethod method) throws NotFoundException {
        String src = JavassistInstrumentor.createParameterTypesArray((CtBehavior)method);
        src = src + "java.lang.reflect.Method method = this.getClass().getDeclaredMethod(\"" + method.getName() + "\", parameterTypes);";
        return src;
    }

    private static String createConstructorObject(CtConstructor constructor) throws NotFoundException {
        String src = JavassistInstrumentor.createParameterTypesArray((CtBehavior)constructor);
        src = src + "java.lang.reflect.Constructor constructor = this.getClass().getDeclaredConstructor(parameterTypes);";
        return src;
    }

    private static boolean isInstrumentable(CtClass clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract((int)modifiers) && !Modifier.isInterface((int)modifiers) && !Modifier.isEnum((int)modifiers);
    }
}

