/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javassist.ClassPool;
import javassist.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketClassLoader
extends Loader {
    private List<String> classes;
    private File wicketComponentDirectory;

    public WicketClassLoader(List<String> classes, File wicketComponentDirectory) {
        this.classes = classes;
        this.wicketComponentDirectory = wicketComponentDirectory;
    }

    public WicketClassLoader(ClassLoader parent, ClassPool cp, List<String> classes, File wicketComponentDirectory) {
        super(parent, cp);
        this.classes = classes;
        this.wicketComponentDirectory = wicketComponentDirectory;
    }

    public WicketClassLoader(ClassPool cp, List<String> classes, File wicketComponentDirectory) {
        super(cp);
        this.classes = classes;
        this.wicketComponentDirectory = wicketComponentDirectory;
    }

    protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
        Class clazz = super.loadClassByDelegation(name);
        if (clazz == null && !this.classes.contains(name)) {
            clazz = this.delegateToParent(name);
        }
        return clazz;
    }

    public URL getResource(String name) {
        File file = new File(this.wicketComponentDirectory, name);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getParent() != null) {
            return this.getParent().getResource(name);
        }
        return null;
    }
}

