/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.web;

import java.util.HashMap;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.wicket.protocol.http.WicketFilter;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.web.FilterConfigWrapper;
import org.jboss.seam.wicket.WebApplication;
import org.jboss.seam.wicket.ioc.JavassistInstrumentor;

@Name(value="org.jboss.seam.wicket.web.wicketFilterInstantiator")
@Install(precedence=0, classDependencies={"org.apache.wicket.Application"})
@BypassInterceptors
@Scope(value=ScopeType.STATELESS)
public class WicketFilterInstantiator {
    @Unwrap
    public Filter unrwap() {
        return new WicketFilter(){
            private ClassLoader classLoader;

            public void init(FilterConfig filterConfig) throws ServletException {
                HashMap<String, String> parameters = new HashMap<String, String>();
                try {
                    JavassistInstrumentor javassistInstrumentor = new JavassistInstrumentor(filterConfig.getServletContext());
                    javassistInstrumentor.instrument();
                    this.classLoader = javassistInstrumentor.getClassLoader();
                }
                catch (NotFoundException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (CannotCompileException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new ServletException((Throwable)e);
                }
                if (filterConfig.getInitParameter("applicationClassName") == null) {
                    String applicationClass = WebApplication.instance().getApplicationClass();
                    if (applicationClass != null) {
                        parameters.put("applicationClassName", applicationClass);
                    } else {
                        throw new IllegalStateException("Must set application-class using <wicket:web-application /> in components.xml");
                    }
                }
                super.init((FilterConfig)new FilterConfigWrapper(filterConfig, parameters));
            }

            protected ClassLoader getClassLoader() {
                return this.classLoader;
            }
        };
    }
}

