/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.wicket.WicketComponent;

public class SeamAuthorizationStrategy
implements IAuthorizationStrategy {
    private LogProvider log = Logging.getLogProvider(SeamAuthorizationStrategy.class);
    private Class loginPage;

    public SeamAuthorizationStrategy(Class loginPage) {
        this.loginPage = loginPage;
    }

    public boolean isActionAuthorized(Component component, Action action) {
        return this.isInstantiationAuthorized(component.getClass());
    }

    public boolean isInstantiationAuthorized(Class componentClass) {
        try {
            WicketComponent instance = WicketComponent.getInstance(componentClass);
            if (instance != null) {
                instance.checkRestrictions();
            }
        }
        catch (NotLoggedInException e) {
            this.log.error((Object)("Unauthorized access to " + componentClass.getName() + ", user not logged in"), (Throwable)e);
            return this.handleException(componentClass);
        }
        catch (AuthorizationException e) {
            return false;
        }
        return true;
    }

    private boolean handleException(Class componentClass) {
        if (Page.class.isAssignableFrom(componentClass)) {
            throw new RestartResponseAtInterceptPageException(this.loginPage);
        }
        return false;
    }
}

