/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import org.jboss.seam.wicket.WicketComponent;
import org.jboss.seam.wicket.ioc.InstrumentedComponent;
import org.jboss.seam.wicket.ioc.InvocationContext;
import org.jboss.seam.wicket.ioc.StatelessInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BijectionInterceptor<T>
implements StatelessInterceptor<T> {
    @Override
    public Object afterInvoke(InvocationContext<T> invocationContext, Object result) {
        invocationContext.getComponent().outject(invocationContext.getBean());
        invocationContext.getComponent().disinject(invocationContext.getBean());
        BijectionInterceptor.disinjectEnclosingInstances(invocationContext);
        return result;
    }

    @Override
    public void beforeInvoke(InvocationContext<T> invocationContext) {
        try {
            invocationContext.getComponent().inject(invocationContext.getBean());
            BijectionInterceptor.injectEnclosingInstances(invocationContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Exception handleException(InvocationContext<T> invocationContext, Exception exception) {
        return exception;
    }

    private static <T> void injectEnclosingInstances(InvocationContext<T> invocationContext) {
        for (InstrumentedComponent enclosingInstance = invocationContext.getInstrumentedComponent().getEnclosingInstance(); enclosingInstance != null; enclosingInstance = enclosingInstance.getEnclosingInstance()) {
            if (enclosingInstance.getHandler() != null && !enclosingInstance.getHandler().isReentrant()) {
                WicketComponent.getInstance(enclosingInstance.getClass()).inject(enclosingInstance);
                continue;
            }
            return;
        }
    }

    private static <T> void disinjectEnclosingInstances(InvocationContext<T> invocationContext) {
        for (InstrumentedComponent enclosingInstance = invocationContext.getInstrumentedComponent().getEnclosingInstance(); enclosingInstance != null; enclosingInstance = enclosingInstance.getEnclosingInstance()) {
            if (enclosingInstance.getHandler() != null && !enclosingInstance.getHandler().isReentrant()) {
                WicketComponent.getInstance(enclosingInstance.getClass()).disinject(enclosingInstance);
                continue;
            }
            return;
        }
    }
}

