/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.seam.annotations.ApplicationException;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.bpm.BeginTask;
import org.jboss.seam.annotations.bpm.EndTask;
import org.jboss.seam.annotations.bpm.StartTask;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.wicket.ioc.InvocationContext;
import org.jboss.seam.wicket.ioc.StatelessInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationInterceptor<T>
implements StatelessInterceptor<T> {
    @Override
    public void beforeInvoke(InvocationContext<T> invocationContext) {
        if (invocationContext.getComponent().isConversationManagementMethod(invocationContext.getAccessibleObject()) && this.isMissingJoin(invocationContext)) {
            throw new IllegalStateException("begin method invoked from a long-running conversation, try using @Begin(join=true) on method: " + invocationContext.getMember().getName());
        }
    }

    @Override
    public Object afterInvoke(InvocationContext<T> invocationContext, Object result) {
        if (invocationContext.getComponent().isConversationManagementMethod(invocationContext.getAccessibleObject())) {
            this.beginConversationIfNecessary(invocationContext, result);
            this.endConversationIfNecessary(invocationContext, result);
        }
        return result;
    }

    @Override
    public Exception handleException(InvocationContext<T> invocationContext, Exception exception) {
        if (this.isEndConversationRequired(exception)) {
            this.endConversation(false);
        }
        return exception;
    }

    private boolean isEndConversationRequired(Exception e) {
        Class<?> clazz = e.getClass();
        return clazz.isAnnotationPresent(ApplicationException.class) && clazz.getAnnotation(ApplicationException.class).end();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean redirectToExistingConversation(Method method) {
        String conversation;
        if (Manager.instance().isLongRunningConversation()) return false;
        String id = null;
        ConversationPropagation propagation = ConversationPropagation.instance();
        String string = conversation = propagation != null ? propagation.getConversationName() : null;
        if (method.isAnnotationPresent(Begin.class)) {
            id = method.getAnnotation(Begin.class).id();
        } else if (method.isAnnotationPresent(BeginTask.class)) {
            id = method.getAnnotation(BeginTask.class).id();
        } else if (method.isAnnotationPresent(StartTask.class)) {
            id = method.getAnnotation(StartTask.class).id();
        }
        if (id != null && !"".equals(id)) {
            id = Interpolator.instance().interpolate(id, new Object[0]);
            ConversationEntry ce = ConversationEntries.instance().getConversationEntry(id);
            if (ce != null) return ce.redirect();
            Manager.instance().updateCurrentConversationId(id);
            return false;
        } else {
            ConversationEntry ce;
            ConversationIdParameter param;
            if (conversation == null || "".equals(conversation) || (param = Pages.instance().getConversationIdParameter(conversation)) == null || (ce = ConversationEntries.instance().getConversationEntry(param.getConversationId())) == null) return false;
            return ce.redirect();
        }
    }

    private boolean isMissingJoin(InvocationContext invocationContext) {
        return Manager.instance().isLongRunningOrNestedConversation() && (invocationContext.getAccessibleObject().isAnnotationPresent(Begin.class) && !invocationContext.getAccessibleObject().getAnnotation(Begin.class).join() && !invocationContext.getAccessibleObject().getAnnotation(Begin.class).nested() || invocationContext.getAccessibleObject().isAnnotationPresent(BeginTask.class) || invocationContext.getAccessibleObject().isAnnotationPresent(StartTask.class));
    }

    private void beginConversationIfNecessary(InvocationContext invocationContext, Object result) {
        String[] outcomes;
        boolean simpleBegin;
        boolean bl = simpleBegin = invocationContext.getAccessibleObject().isAnnotationPresent(StartTask.class) || invocationContext.getAccessibleObject().isAnnotationPresent(BeginTask.class) || invocationContext.getAccessibleObject().isAnnotationPresent(Begin.class) && invocationContext.getAccessibleObject().getAnnotation(Begin.class).ifOutcome().length == 0;
        if (simpleBegin) {
            if (result != null || invocationContext.getMethod() != null && invocationContext.getMethod().getReturnType().equals(Void.TYPE) || invocationContext.getConstructor() != null) {
                boolean nested = false;
                if (invocationContext.getAccessibleObject().isAnnotationPresent(Begin.class)) {
                    nested = invocationContext.getAccessibleObject().getAnnotation(Begin.class).nested();
                }
                this.beginConversation(nested, this.getProcessDefinitionName(invocationContext));
                this.setFlushMode(invocationContext);
            }
        } else if (invocationContext.getAccessibleObject().isAnnotationPresent(Begin.class) && ((outcomes = invocationContext.getAccessibleObject().getAnnotation(Begin.class).ifOutcome()).length == 0 || Arrays.asList(outcomes).contains(result))) {
            this.beginConversation(invocationContext.getAccessibleObject().getAnnotation(Begin.class).nested(), this.getProcessDefinitionName(invocationContext));
            this.setFlushMode(invocationContext);
        }
    }

    private void setFlushMode(InvocationContext<T> invocationContext) {
        FlushModeType flushMode;
        if (invocationContext.getAccessibleObject().isAnnotationPresent(Begin.class)) {
            flushMode = invocationContext.getAccessibleObject().getAnnotation(Begin.class).flushMode();
        } else if (invocationContext.getAccessibleObject().isAnnotationPresent(BeginTask.class)) {
            flushMode = invocationContext.getAccessibleObject().getAnnotation(BeginTask.class).flushMode();
        } else if (invocationContext.getAccessibleObject().isAnnotationPresent(StartTask.class)) {
            flushMode = invocationContext.getAccessibleObject().getAnnotation(StartTask.class).flushMode();
        } else {
            return;
        }
        PersistenceContexts.instance().changeFlushMode(flushMode);
    }

    private String getProcessDefinitionName(InvocationContext invocationContext) {
        if (invocationContext.getAccessibleObject().isAnnotationPresent(Begin.class)) {
            return invocationContext.getAccessibleObject().getAnnotation(Begin.class).pageflow();
        }
        if (invocationContext.getAccessibleObject().isAnnotationPresent(BeginTask.class)) {
            return invocationContext.getAccessibleObject().getAnnotation(BeginTask.class).pageflow();
        }
        if (invocationContext.getAccessibleObject().isAnnotationPresent(StartTask.class)) {
            return invocationContext.getAccessibleObject().getAnnotation(StartTask.class).pageflow();
        }
        return "";
    }

    private void beginConversation(boolean nested, String pageflowName) {
        if (!Manager.instance().isLongRunningOrNestedConversation()) {
            Manager.instance().beginConversation();
            this.beginNavigation(pageflowName);
        } else if (nested) {
            Manager.instance().beginNestedConversation();
            this.beginNavigation(pageflowName);
        }
    }

    private void beginNavigation(String pageflowName) {
        if (!pageflowName.equals("")) {
            Pageflow.instance().begin(pageflowName);
        }
    }

    private void endConversationIfNecessary(InvocationContext<T> invocationContext, Object result) {
        String[] outcomes;
        boolean simpleEnd;
        boolean isEndAnnotation = invocationContext.getAccessibleObject().isAnnotationPresent(End.class);
        boolean isEndTaskAnnotation = invocationContext.getAccessibleObject().isAnnotationPresent(EndTask.class);
        boolean beforeRedirect = isEndAnnotation && invocationContext.getAccessibleObject().getAnnotation(End.class).beforeRedirect() || isEndTaskAnnotation && invocationContext.getAccessibleObject().getAnnotation(EndTask.class).beforeRedirect();
        boolean bl = simpleEnd = isEndAnnotation && invocationContext.getAccessibleObject().getAnnotation(End.class).ifOutcome().length == 0 || isEndTaskAnnotation && invocationContext.getAccessibleObject().getAnnotation(EndTask.class).ifOutcome().length == 0;
        if (simpleEnd) {
            if (result != null || invocationContext.getConstructor() != null || invocationContext.getMethod() != null && invocationContext.getMethod().getReturnType().equals(Void.TYPE)) {
                this.endConversation(beforeRedirect);
            }
        } else if (isEndAnnotation) {
            String[] outcomes2 = invocationContext.getAccessibleObject().getAnnotation(End.class).ifOutcome();
            if (Arrays.asList(outcomes2).contains(result)) {
                this.endConversation(beforeRedirect);
            }
        } else if (isEndTaskAnnotation && Arrays.asList(outcomes = invocationContext.getAccessibleObject().getAnnotation(EndTask.class).ifOutcome()).contains(result)) {
            this.endConversation(beforeRedirect);
        }
    }

    private void endConversation(boolean beforeRedirect) {
        Manager.instance().endConversation(beforeRedirect);
    }
}

