/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.Loader;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.jboss.seam.deployment.ClassDescriptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.wicket.ioc.JavassistInstrumentor;

public class WicketClassLoader
extends Loader {
    private static LogProvider log = Logging.getLogProvider(WicketClassLoader.class);
    private List<String> classes = new ArrayList<String>();
    private File wicketComponentDirectory;
    private ClassPool classPool;
    private ClassLoader parentLoader;
    private JavassistInstrumentor instrumentor;

    public WicketClassLoader(ClassLoader parent, ClassPool classPool, File wicketComponentDirectory) {
        super(parent, classPool);
        this.wicketComponentDirectory = wicketComponentDirectory;
        this.classPool = classPool;
        this.parentLoader = parent;
        this.instrumentor = new JavassistInstrumentor(classPool);
    }

    public WicketClassLoader instrument() throws NotFoundException, CannotCompileException, ClassNotFoundException {
        this.classPool.insertClassPath(this.wicketComponentDirectory.getAbsolutePath());
        this.classPool.insertClassPath((ClassPath)new LoaderClassPath(this.parentLoader));
        if (this.wicketComponentDirectory.exists()) {
            this.handleDirectory(this.wicketComponentDirectory, null);
        }
        for (String className : this.classes) {
            this.loadClass(className);
        }
        return this;
    }

    private void handleDirectory(File file, String path) throws NotFoundException, CannotCompileException {
        log.trace((Object)("directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this.handleItem(newPath);
        }
    }

    private void handleItem(String path) throws NotFoundException, CannotCompileException {
        if (path.endsWith(".class")) {
            this.classes.add(this.instrumentor.instrumentClass(ClassDescriptor.filenameToClassname((String)path)).getName());
        }
    }

    protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
        Class clazz = super.loadClassByDelegation(name);
        if (clazz == null && !this.classes.contains(name)) {
            clazz = this.delegateToParent(name);
        }
        return clazz;
    }

    public URL getResource(String name) {
        File file = new File(this.wicketComponentDirectory, name);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getParent() != null) {
            return this.getParent().getResource(name);
        }
        return null;
    }
}

