/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.web.AbstractFilter;
import org.jboss.seam.wicket.WicketManager;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.redirectFilter")
@Install(precedence=10, classDependencies={"org.apache.wicket.Application"})
@BypassInterceptors
@Filter
public class WicketRedirectFilter
extends AbstractFilter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, WicketRedirectFilter.wrapResponse((HttpServletResponse)response));
    }

    private static ServletResponse wrapResponse(HttpServletResponse response) {
        return new HttpServletResponseWrapper(response){

            public void sendRedirect(String url) throws IOException {
                if (Contexts.isEventContextActive() && !Contexts.getEventContext().isSet("org.jboss.seam.core.Manager") && Contexts.isConversationContextActive()) {
                    url = WicketManager.instance().appendConversationIdFromRedirectFilter(url);
                }
                super.sendRedirect(url);
            }
        };
    }
}

