/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.wicket.WicketComponent;
import org.jboss.seam.wicket.ioc.InstrumentedComponent;
import org.jboss.seam.wicket.ioc.WicketHandler;

public class JavassistInstrumentor {
    private static LogProvider log = Logging.getLogProvider(JavassistInstrumentor.class);
    private ClassPool classPool;

    public JavassistInstrumentor(ClassPool classPool) {
        this.classPool = classPool;
    }

    public CtClass instrumentClass(String className) throws NotFoundException, CannotCompileException {
        log.debug((Object)("Instrumenting " + className));
        CtClass implementation = this.classPool.get(className);
        if (JavassistInstrumentor.isInstrumentable(implementation)) {
            CtClass handlerClass = this.classPool.get(WicketHandler.class.getName());
            CtClass componentClass = this.classPool.get(WicketComponent.class.getName());
            CtField handlerField = new CtField(handlerClass, "handler", implementation);
            CtField.Initializer handlerInitializer = CtField.Initializer.byCall((CtClass)handlerClass, (String)"create");
            implementation.addField(handlerField, handlerInitializer);
            CtField wicketComponentField = new CtField(componentClass, "component", implementation);
            wicketComponentField.setModifiers(8);
            CtField.Initializer componentInit = CtField.Initializer.byExpr((String)("new org.jboss.seam.wicket.WicketComponent(" + className + ".class)"));
            implementation.addField(wicketComponentField, componentInit);
            CtClass exception = this.classPool.get(Exception.class.getName());
            CtClass instrumentedComponent = this.classPool.get(InstrumentedComponent.class.getName());
            implementation.addInterface(instrumentedComponent);
            CtMethod getHandlerMethod = CtNewMethod.getter((String)"getHandler", (CtField)handlerField);
            CtMethod getEnclosingInstance = CtNewMethod.make((String)("public " + InstrumentedComponent.class.getName() + " getEnclosingInstance() { return handler == null ? null : handler.getEnclosingInstance(this); }"), (CtClass)implementation);
            implementation.addMethod(getEnclosingInstance);
            implementation.addMethod(getHandlerMethod);
            for (CtMethod ctMethod : implementation.getDeclaredMethods()) {
                if (Modifier.isStatic((int)ctMethod.getModifiers()) || Modifier.isAbstract((int)ctMethod.getModifiers()) || "getHandler".equals(ctMethod.getName()) || "getEnclosingInstance".equals(ctMethod.getName())) continue;
                String newName = implementation.makeUniqueName(ctMethod.getName());
                CtMethod newMethod = CtNewMethod.copy((CtMethod)ctMethod, (String)newName, (CtClass)implementation, null);
                newMethod.setModifiers(2);
                implementation.addMethod(newMethod);
                ctMethod.setBody(JavassistInstrumentor.createBody(implementation, ctMethod, newMethod));
                log.trace((Object)("instrumented method " + ctMethod.getName()));
            }
            for (CtMethod ctMethod : implementation.getConstructors()) {
                if (!ctMethod.isConstructor()) continue;
                String constructorObject = JavassistInstrumentor.createConstructorObject(className, (CtConstructor)ctMethod);
                ctMethod.insertBeforeBody(constructorObject + "handler.beforeInvoke(this, constructor);");
                ctMethod.addCatch("{" + constructorObject + "throw new RuntimeException(handler.handleException(this, constructor, e));}", exception, "e");
                ctMethod.insertAfter(constructorObject + "handler.afterInvoke(this, constructor);");
                log.trace((Object)("instrumented constructor " + ctMethod.getName()));
            }
        }
        return implementation;
    }

    private static String createBody(CtClass clazz, CtMethod method, CtMethod newMethod) throws NotFoundException {
        String src = "{" + JavassistInstrumentor.createMethodObject(clazz, method) + "if (this.handler != null) this.handler.beforeInvoke(this, method);" + JavassistInstrumentor.createMethodDelegation(newMethod) + "if (this.handler != null) result = ($r) this.handler.afterInvoke(this, method, ($w) result); return ($r) result;}";
        log.trace((Object)("Creating method " + clazz.getName() + "." + newMethod.getName() + "(" + newMethod.getSignature() + ")" + src));
        return src;
    }

    private static String createMethodDelegation(CtMethod method) throws NotFoundException {
        CtClass returnType = method.getReturnType();
        if (returnType.equals(CtClass.voidType)) {
            return "Object result = null; " + JavassistInstrumentor.wrapInExceptionHandler(method.getName() + "($$);");
        }
        String src = returnType.getName() + " result;";
        src = src + JavassistInstrumentor.wrapInExceptionHandler("result = " + method.getName() + "($$);");
        return src;
    }

    private static String wrapInExceptionHandler(String src) {
        return "try {" + src + "} catch (Exception e) { throw new RuntimeException(this.handler == null ? e : this.handler.handleException(this, method, e)); }";
    }

    private static String createParameterTypesArray(CtBehavior behavior) throws NotFoundException {
        String src = "Class[] parameterTypes = new Class[" + behavior.getParameterTypes().length + "];";
        for (int i = 0; i < behavior.getParameterTypes().length; ++i) {
            src = src + "parameterTypes[" + i + "] = " + behavior.getParameterTypes()[i].getName() + ".class;";
        }
        return src;
    }

    private static String createMethodObject(CtClass clazz, CtMethod method) throws NotFoundException {
        String src = JavassistInstrumentor.createParameterTypesArray((CtBehavior)method);
        src = src + "java.lang.reflect.Method method = " + clazz.getName() + ".class.getDeclaredMethod(\"" + method.getName() + "\", parameterTypes);";
        return src;
    }

    private static String createConstructorObject(String className, CtConstructor constructor) throws NotFoundException {
        String src = JavassistInstrumentor.createParameterTypesArray((CtBehavior)constructor);
        src = src + "java.lang.reflect.Constructor constructor = " + className + ".class.getDeclaredConstructor(parameterTypes);";
        return src;
    }

    private static boolean isInstrumentable(CtClass clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isInterface((int)modifiers) && !Modifier.isEnum((int)modifiers);
    }
}

