/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.international;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.wicket.international.WicketStatusMessages;

public class SeamStatusMessagesListener
implements IComponentOnBeforeRenderListener {
    public void onBeforeRender(Component component) {
        List<StatusMessage> statusMessages;
        WicketStatusMessages wicketStatusMessages = WicketStatusMessages.instance();
        wicketStatusMessages.onBeforeRender();
        if (component instanceof Page) {
            statusMessages = wicketStatusMessages.getGlobalMessages();
            if (statusMessages != null) {
                for (StatusMessage statusMessage : statusMessages) {
                    this.addFeedbackMessage(statusMessage, component);
                }
            }
            wicketStatusMessages.clearGlobalMessages();
        }
        if ((statusMessages = wicketStatusMessages.getKeyedMessages(component.getId())) != null) {
            for (StatusMessage statusMessage : statusMessages) {
                this.addFeedbackMessage(statusMessage, component);
            }
            wicketStatusMessages.clearKeyedMessages(component.getId());
        }
    }

    private void addFeedbackMessage(StatusMessage statusMessage, Component component) {
        switch (statusMessage.getSeverity()) {
            case ERROR: {
                component.error((Serializable)((Object)statusMessage.getSummary()));
                break;
            }
            case FATAL: {
                component.fatal(statusMessage.getSummary());
                break;
            }
            case INFO: {
                component.info(statusMessage.getSummary());
                break;
            }
            case WARN: {
                component.warn(statusMessage.getSummary());
            }
        }
    }
}

