/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.Loader;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.jboss.seam.deployment.ClassDescriptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.wicket.ioc.JavassistInstrumentor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketClassLoader
extends Loader {
    private static LogProvider log = Logging.getLogProvider(WicketClassLoader.class);
    private Set<String> classes = new HashSet<String>();
    private File wicketComponentDirectory;
    private ClassPool classPool;
    private ClassLoader parentLoader;
    private JavassistInstrumentor instrumentor;

    public WicketClassLoader(ClassLoader parent, ClassPool classPool, File wicketComponentDirectory) {
        super(parent, classPool);
        this.wicketComponentDirectory = wicketComponentDirectory;
        this.classPool = classPool;
        this.parentLoader = parent;
        this.instrumentor = new JavassistInstrumentor(classPool);
    }

    public WicketClassLoader instrument() throws NotFoundException, CannotCompileException, ClassNotFoundException {
        this.classPool.insertClassPath(this.wicketComponentDirectory.getAbsolutePath());
        this.classPool.insertClassPath((ClassPath)new LoaderClassPath(this.parentLoader));
        if (this.wicketComponentDirectory.exists()) {
            this.handleDirectory(this.wicketComponentDirectory, null, this.classes);
            this.instrumentor.instrumentClassSet(this.classes, null);
        }
        for (String className : this.classes) {
            this.loadClass(className);
        }
        return this;
    }

    private void handleDirectory(File file, String path, Set<String> collectedClasses) throws NotFoundException, CannotCompileException {
        log.trace((Object)("directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, collectedClasses);
                continue;
            }
            if (!newPath.endsWith(".class")) continue;
            collectedClasses.add(ClassDescriptor.filenameToClassname((String)newPath));
        }
    }

    protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
        Class clazz = super.loadClassByDelegation(name);
        if (clazz == null && !this.classes.contains(name)) {
            clazz = this.delegateToParent(name);
        }
        return clazz;
    }

    public URL getResource(String name) {
        File file = new File(this.wicketComponentDirectory, name);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getParent() != null) {
            return this.getParent().getResource(name);
        }
        return null;
    }
}

