/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.seam.wicket.WicketComponent;
import org.jboss.seam.wicket.ioc.InstrumentedComponent;
import org.jboss.seam.wicket.ioc.InvocationContext;
import org.jboss.seam.wicket.ioc.StatelessInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketHandler
implements Serializable {
    private Class<?> type;
    private transient WicketComponent component;
    private int reentrant = 0;

    public static WicketHandler create(Object bean) {
        WicketHandler handler = new WicketHandler(bean.getClass());
        return handler;
    }

    public WicketHandler(Class<?> type) {
        this.type = type;
    }

    private WicketComponent getComponent() {
        if (this.component == null) {
            this.component = WicketComponent.getInstance(this.type);
        }
        return this.component;
    }

    public void beforeInvoke(Object target, Method calledMethod) {
        this.doBeforeInvoke(new InvocationContext<Object>(calledMethod, target, this.getComponent()));
    }

    public Object afterInvoke(Object target, Method calledMethod, Object result) {
        return this.doAfterInvoke(new InvocationContext<Object>(calledMethod, target, this.getComponent()), result);
    }

    public void beforeInvoke(Object target, Constructor constructor) {
        this.getComponent().initialize(target);
        this.doBeforeInvoke(new InvocationContext<Object>(constructor, target, this.getComponent()));
    }

    public void afterInvoke(Object target, Constructor constructor) {
        this.doAfterInvoke(new InvocationContext<Object>(constructor, target, this.getComponent()), null);
    }

    private void doBeforeInvoke(InvocationContext invocationContext) {
        if (this.reentrant == 0) {
            for (StatelessInterceptor interceptor : this.getComponent().getInterceptors()) {
                interceptor.beforeInvoke(invocationContext);
            }
        }
        ++this.reentrant;
        InstrumentedComponent enclosing = this.getEnclosingInstance(invocationContext.getBean());
        if (enclosing != null && enclosing.getHandler() != null) {
            enclosing.getHandler().injectEnclosingInstance(enclosing);
        }
    }

    protected void injectEnclosingInstance(InstrumentedComponent instance) {
        if (this.reentrant == 0) {
            this.getComponent().inject(instance);
        }
        ++this.reentrant;
        if ((instance = instance.getEnclosingInstance()) != null) {
            instance.getHandler().injectEnclosingInstance(instance);
        }
    }

    public Exception handleException(Object target, Method method, Exception exception) {
        return this.doHandleException(new InvocationContext<Object>(method, target, this.getComponent()), exception);
    }

    public Exception handleException(Object target, Constructor constructor, Exception exception) {
        return this.doHandleException(new InvocationContext<Object>(constructor, target, this.getComponent()), exception);
    }

    private Exception doHandleException(InvocationContext invocationContext, Exception exception) {
        --this.reentrant;
        if (this.reentrant == 0) {
            for (StatelessInterceptor interceptor : this.getComponent().getInterceptors()) {
                exception = interceptor.handleException(invocationContext, exception);
            }
        }
        return exception;
    }

    private Object doAfterInvoke(InvocationContext invocationContext, Object result) {
        InstrumentedComponent enclosing;
        --this.reentrant;
        if (this.reentrant == 0) {
            for (int i = this.getComponent().getInterceptors().size() - 1; i >= 0; --i) {
                result = this.getComponent().getInterceptors().get(i).afterInvoke(invocationContext, result);
            }
        }
        if ((enclosing = this.getEnclosingInstance(invocationContext.getBean())) != null && enclosing.getHandler() != null) {
            enclosing.getHandler().disinjectEnclosingInstance(enclosing);
        }
        return result;
    }

    protected void disinjectEnclosingInstance(InstrumentedComponent instance) {
        --this.reentrant;
        if (this.reentrant == 0) {
            this.getComponent().disinject(instance);
        }
        if ((instance = instance.getEnclosingInstance()) != null) {
            instance.getHandler().disinjectEnclosingInstance(instance);
        }
    }

    public boolean isReentrant() {
        return this.reentrant > 0;
    }

    public InstrumentedComponent getEnclosingInstance(Object bean) {
        Class<?> enclosingType = this.getComponent().getClass();
        if (enclosingType != null) {
            try {
                Field enclosingField = bean.getClass().getDeclaredField(this.getComponent().getEnclosingInstanceVariableName());
                enclosingField.setAccessible(true);
                Object enclosingInstance = enclosingField.get(bean);
                if (enclosingInstance instanceof InstrumentedComponent) {
                    return (InstrumentedComponent)enclosingInstance;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

