/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.wicket.ioc.BijectedAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BijectedMethod<T extends Annotation>
implements BijectedAttribute<T> {
    private Method method;
    private T annotation;
    private String contextVariableName;

    public BijectedMethod(Method method, T annotation) {
        this.method = method;
        this.annotation = annotation;
        this.contextVariableName = this.getSpecifiedContextVariableName();
        if (this.contextVariableName == null || "".equals(this.contextVariableName)) {
            if (method.getName().matches("^(get|set).*") && method.getParameterTypes().length == 0) {
                this.contextVariableName = method.getName().substring(3);
            } else if (method.getName().matches("^(is).*") && method.getParameterTypes().length == 0) {
                this.contextVariableName = method.getName().substring(2);
            }
        }
    }

    @Override
    public Method getMember() {
        return this.method;
    }

    @Override
    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public void set(Object bean, Object value) {
        this.method.setAccessible(true);
        Reflections.invokeAndWrap((Method)this.method, (Object)bean, (Object[])new Object[]{value});
    }

    @Override
    public Object get(Object bean) {
        this.method.setAccessible(true);
        return Reflections.invokeAndWrap((Method)this.method, (Object)bean, (Object[])new Object[0]);
    }

    @Override
    public Class getType() {
        return this.method.getParameterTypes()[0];
    }

    public String toString() {
        return "BijectedMethod(" + Reflections.toString((Method)this.method) + ')';
    }

    protected abstract String getSpecifiedContextVariableName();

    @Override
    public String getContextVariableName() {
        return this.contextVariableName;
    }
}

