/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.wicket.WicketComponent;
import org.jboss.seam.wicket.ioc.InstrumentedComponent;
import org.jboss.seam.wicket.ioc.SeamWicketComponent;
import org.jboss.seam.wicket.ioc.WicketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistInstrumentor
implements ClassFileTransformer {
    private static LogProvider log = Logging.getLogProvider(JavassistInstrumentor.class);
    private ClassPool classPool;
    private Set<String> packagesToInstrument;
    private CtClass instrumentedComponent;
    private boolean scanAnnotations;
    private Set<String> onlyTheseClasses;

    public JavassistInstrumentor(ClassPool classPool) {
        this(classPool, false);
    }

    public JavassistInstrumentor(ClassPool classPool, boolean scanAnnotations) {
        this.classPool = classPool;
        this.scanAnnotations = scanAnnotations;
    }

    public JavassistInstrumentor(ClassPool classPool, Set<String> packagesToInstrument, boolean scanAnnotations) {
        this(classPool, scanAnnotations);
        this.packagesToInstrument = packagesToInstrument;
    }

    public CtClass instrumentClass(String className) throws NotFoundException, CannotCompileException {
        log.debug((Object)("Examining " + className));
        CtClass implementation = this.classPool.get(className);
        if (this.isInstrumentable(implementation)) {
            log.debug((Object)("Instrumenting " + className));
            this.instrumentClass(implementation);
        }
        return implementation;
    }

    public CtClass instrumentClass(byte[] bytes) throws IOException, RuntimeException, NotFoundException, CannotCompileException {
        CtClass clazz = this.classPool.makeClass((InputStream)new ByteArrayInputStream(bytes));
        if (this.isInstrumentable(clazz)) {
            this.instrumentClass(clazz);
            return clazz;
        }
        return null;
    }

    public void instrumentClass(CtClass implementation) throws NotFoundException, CannotCompileException {
        String className = implementation.getName();
        CtClass handlerClass = this.classPool.get(WicketHandler.class.getName());
        CtClass componentClass = this.classPool.get(WicketComponent.class.getName());
        CtClass superclass = implementation.getSuperclass();
        if (!this.isInstrumented(superclass)) {
            if (!this.isInstrumentable(superclass)) {
                CtField handlerField = new CtField(handlerClass, "handler", implementation);
                handlerField.setModifiers(4);
                CtField.Initializer handlerInitializer = CtField.Initializer.byCall((CtClass)handlerClass, (String)"create");
                implementation.addField(handlerField, handlerInitializer);
                CtMethod getHandlerMethod = CtNewMethod.getter((String)"getHandler", (CtField)handlerField);
                implementation.addMethod(getHandlerMethod);
            } else {
                this.instrumentClass(superclass);
            }
        }
        CtField wicketComponentField = new CtField(componentClass, "component", implementation);
        wicketComponentField.setModifiers(8);
        CtField.Initializer componentInit = CtField.Initializer.byExpr((String)("new org.jboss.seam.wicket.WicketComponent(" + className + ".class)"));
        implementation.addField(wicketComponentField, componentInit);
        CtClass exception = this.classPool.get(Exception.class.getName());
        implementation.addInterface(this.getInstrumentedComponentInterface());
        CtMethod getEnclosingInstance = CtNewMethod.make((String)("public " + InstrumentedComponent.class.getName() + " getEnclosingInstance() { return getHandler() == null ? null : getHandler().getEnclosingInstance(this); }"), (CtClass)implementation);
        implementation.addMethod(getEnclosingInstance);
        for (CtMethod ctMethod : implementation.getDeclaredMethods()) {
            if (Modifier.isStatic((int)ctMethod.getModifiers()) || Modifier.isAbstract((int)ctMethod.getModifiers()) || "getHandler".equals(ctMethod.getName()) || "getEnclosingInstance".equals(ctMethod.getName())) continue;
            String newName = implementation.makeUniqueName(ctMethod.getName());
            CtMethod newMethod = CtNewMethod.copy((CtMethod)ctMethod, (String)newName, (CtClass)implementation, null);
            newMethod.setModifiers(2);
            implementation.addMethod(newMethod);
            ctMethod.setBody(JavassistInstrumentor.createBody(implementation, ctMethod, newMethod));
            log.trace((Object)("instrumented method " + ctMethod.getName()));
        }
        for (CtMethod ctMethod : implementation.getConstructors()) {
            if (!ctMethod.isConstructor()) continue;
            String constructorObject = JavassistInstrumentor.createConstructorObject(className, (CtConstructor)ctMethod);
            ctMethod.insertBeforeBody(constructorObject + "getHandler().beforeInvoke(this, constructor);");
            ctMethod.addCatch("{" + constructorObject + "throw new RuntimeException(getHandler().handleException(this, constructor, e));}", exception, "e");
            ctMethod.insertAfter(constructorObject + "getHandler().afterInvoke(this, constructor);");
            log.trace((Object)("instrumented constructor " + ctMethod.getName()));
        }
    }

    private static String createBody(CtClass clazz, CtMethod method, CtMethod newMethod) throws NotFoundException {
        String src = "{" + JavassistInstrumentor.createMethodObject(clazz, method) + "if (getHandler() != null) getHandler().beforeInvoke(this, method);" + JavassistInstrumentor.createMethodDelegation(newMethod) + "if (this.handler != null) result = ($r) this.handler.afterInvoke(this, method, ($w) result); return ($r) result;}";
        log.trace((Object)("Creating method " + clazz.getName() + "." + newMethod.getName() + "(" + newMethod.getSignature() + ")" + src));
        return src;
    }

    private static String createMethodDelegation(CtMethod method) throws NotFoundException {
        CtClass returnType = method.getReturnType();
        if (returnType.equals(CtClass.voidType)) {
            return "Object result = null; " + JavassistInstrumentor.wrapInExceptionHandler(method.getName() + "($$);");
        }
        String src = returnType.getName() + " result;";
        src = src + JavassistInstrumentor.wrapInExceptionHandler("result = " + method.getName() + "($$);");
        return src;
    }

    private static String wrapInExceptionHandler(String src) {
        return "try {" + src + "} catch (Exception e) { throw new RuntimeException(getHandler() == null ? e : getHandler().handleException(this, method, e)); }";
    }

    private static String createParameterTypesArray(CtBehavior behavior) throws NotFoundException {
        String src = "Class[] parameterTypes = new Class[" + behavior.getParameterTypes().length + "];";
        for (int i = 0; i < behavior.getParameterTypes().length; ++i) {
            src = src + "parameterTypes[" + i + "] = " + behavior.getParameterTypes()[i].getName() + ".class;";
        }
        return src;
    }

    private static String createMethodObject(CtClass clazz, CtMethod method) throws NotFoundException {
        String src = JavassistInstrumentor.createParameterTypesArray((CtBehavior)method);
        src = src + "java.lang.reflect.Method method = " + clazz.getName() + ".class.getDeclaredMethod(\"" + method.getName() + "\", parameterTypes);";
        return src;
    }

    private static String createConstructorObject(String className, CtConstructor constructor) throws NotFoundException {
        String src = JavassistInstrumentor.createParameterTypesArray((CtBehavior)constructor);
        src = src + "java.lang.reflect.Constructor constructor = " + className + ".class.getDeclaredConstructor(parameterTypes);";
        return src;
    }

    public boolean hasWicketAnnotation(CtClass clazz) {
        try {
            for (Object a : clazz.getAnnotations()) {
                if (!(a instanceof SeamWicketComponent)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean markedInstrumentable(CtClass clazz) {
        if (this.hasWicketAnnotation(clazz)) {
            return true;
        }
        try {
            CtClass enclosing;
            CtClass ctClass = enclosing = Modifier.isStatic((int)clazz.getModifiers()) ? null : clazz.getDeclaringClass();
            if (enclosing != null && this.markedInstrumentable(enclosing)) {
                return true;
            }
            CtClass superclass = clazz.getSuperclass();
            if (superclass != null && this.markedInstrumentable(superclass)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean isInstrumentable(CtClass clazz) {
        int modifiers = clazz.getModifiers();
        if (Modifier.isInterface((int)modifiers) || Modifier.isEnum((int)modifiers)) {
            return false;
        }
        if (this.onlyTheseClasses != null && !this.onlyTheseClasses.contains(clazz.getName())) {
            return false;
        }
        try {
            CtClass checkName = clazz;
            do {
                for (Object a : checkName.getAnnotations()) {
                    if (!(a instanceof Name)) continue;
                    return false;
                }
            } while ((checkName = Modifier.isStatic((int)clazz.getModifiers()) ? null : checkName.getDeclaringClass()) != null);
            if (this.scanAnnotations && !this.markedInstrumentable(clazz)) {
                return false;
            }
            if (this.isInstrumented(clazz)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean isInstrumented(CtClass clazz) {
        for (String inf : clazz.getClassFile2().getInterfaces()) {
            if (!inf.equals(this.getInstrumentedComponentInterface().getName())) continue;
            return true;
        }
        return false;
    }

    private CtClass getInstrumentedComponentInterface() {
        if (this.instrumentedComponent == null) {
            try {
                this.instrumentedComponent = this.classPool.get(InstrumentedComponent.class.getName());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.instrumentedComponent;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        int index = className.lastIndexOf("/");
        if (index < 1) {
            return null;
        }
        String packageName = className.substring(0, index);
        do {
            if (!this.packagesToInstrument.contains(packageName) || className.contains("_javassist_")) continue;
            try {
                CtClass clazz = this.classPool.get(className);
                if (clazz.isModified()) {
                    return clazz.toBytecode();
                }
                clazz = this.instrumentClass(classfileBuffer);
                if (clazz == null) {
                    return null;
                }
                return clazz.toBytecode();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } while ((packageName = (index = packageName.lastIndexOf(47)) < 1 ? "" : packageName.substring(0, index)).length() > 0);
        return null;
    }

    public static void premain(String args, Instrumentation instrumentation) {
        JavassistInstrumentor.initAgent(instrumentation);
    }

    public static void agentmain(String args, Instrumentation instrumentation) {
        JavassistInstrumentor.initAgent(instrumentation);
    }

    private static void initAgent(Instrumentation instrumentation) {
        boolean scanAnnotations;
        HashSet<String> packagesToInstrument = new HashSet<String>();
        String list = System.getProperty("org.jboss.seam.wicket.instrumented-packages");
        String scanAnnotationsProperty = System.getProperty("org.jboss.seam.wicket.scanAnnotations");
        boolean bl = scanAnnotations = scanAnnotationsProperty == null ? false : scanAnnotationsProperty.equals("true");
        if (list == null) {
            return;
        }
        for (String packageName : list.split(",")) {
            packagesToInstrument.add(packageName.replaceAll("\\.", "/"));
        }
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        instrumentation.addTransformer(new JavassistInstrumentor(classPool, packagesToInstrument, scanAnnotations));
    }

    public void instrumentClassSet(Set<String> toInstrument, String path) throws CannotCompileException, NotFoundException {
        this.onlyTheseClasses = toInstrument;
        for (String className : toInstrument) {
            CtClass clazz = this.instrumentClass(className);
            if (path == null || !clazz.isModified()) continue;
            try {
                clazz.writeFile(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

