/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebRequestCycleProcessor;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;
import org.jboss.seam.wicket.SeamAuthorizationStrategy;
import org.jboss.seam.wicket.SeamEnforceConversationListener;
import org.jboss.seam.wicket.SeamWebSession;
import org.jboss.seam.wicket.international.SeamStatusMessagesListener;

public abstract class SeamWebApplication
extends WebApplication {
    private static final LogProvider log = Logging.getLogProvider(SeamWebApplication.class);
    protected boolean destroyContextsLazily = false;
    private static MetaDataKey CID = new MetaDataKey<String>(){};

    public boolean isDestroyContextsLazily() {
        return this.destroyContextsLazily;
    }

    public void setDestroyContextsLazily(boolean destroyContextsLazily) {
        this.destroyContextsLazily = destroyContextsLazily;
    }

    public Session newSession(Request request, Response response) {
        return new SeamWebSession(request);
    }

    protected IRequestCycleProcessor newRequestCycleProcessor() {
        return new WebRequestCycleProcessor(){

            public void respond(RequestCycle requestCycle) {
                Page page;
                super.respond(requestCycle);
                if (Manager.instance().isLongRunningConversation() && (page = RequestCycle.get().getResponsePage()) != null) {
                    page.setMetaData(CID, (Object)Manager.instance().getCurrentConversationId());
                }
            }
        };
    }

    protected void init() {
        super.init();
        this.inititializeSeamSecurity();
        this.initializeSeamStatusMessages();
        this.addPreComponentOnBeforeRenderListener(new SeamEnforceConversationListener());
    }

    protected void inititializeSeamSecurity() {
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new SeamAuthorizationStrategy(this.getLoginPage()));
    }

    protected void initializeSeamStatusMessages() {
        this.addPreComponentOnBeforeRenderListener(new SeamStatusMessagesListener());
    }

    protected abstract Class getLoginPage();

    public RequestCycle newRequestCycle(Request request, Response response) {
        return new SeamWebRequestCycle(this, (WebRequest)request, (Response)((WebResponse)response));
    }

    protected static class SeamWebRequestCycle
    extends WebRequestCycle {
        public SeamWebRequestCycle(WebApplication application, WebRequest request, Response response) {
            super(application, request, response);
        }

        protected void onRequestTargetSet(IRequestTarget target) {
            super.onRequestTargetSet(target);
            Page page = null;
            if (target instanceof BookmarkablePageRequestTarget) {
                page = ((BookmarkablePageRequestTarget)target).getPage();
            } else if (target instanceof IPageRequestTarget) {
                page = ((IPageRequestTarget)target).getPage();
            }
            if (page != null) {
                String cid = (String)((Object)page.getMetaData(CID));
                if (cid != null) {
                    Manager manager = Manager.instance();
                    if (manager.isLongRunningConversation()) {
                        if (!cid.equals(manager.getCurrentConversationId())) {
                            manager.switchConversation(cid);
                        }
                    } else {
                        ConversationPropagation cp = ConversationPropagation.instance();
                        cp.setConversationId(cid);
                        manager.restoreConversation();
                    }
                } else {
                    Manager manager = Manager.instance();
                    if (manager.isLongRunningConversation()) {
                        page.setMetaData(CID, (Object)Manager.instance().getCurrentConversationId());
                    }
                }
            }
        }

        protected void onBeginRequest() {
            HttpServletRequest httpRequest = ((WebRequest)this.request).getHttpServletRequest();
            if (Contexts.getEventContext() != null && ((SeamWebApplication)this.getApplication()).isDestroyContextsLazily() && ServletContexts.instance().getRequest() != httpRequest) {
                this.destroyContexts();
            }
            if (Contexts.getEventContext() == null) {
                ServletLifecycle.beginRequest((HttpServletRequest)httpRequest);
                ServletContexts.instance().setRequest(httpRequest);
                ConversationPropagation.instance().restoreConversationId(this.request.getParameterMap());
                Manager.instance().restoreConversation();
                ServletLifecycle.resumeConversation((HttpServletRequest)httpRequest);
                Manager.instance().handleConversationPropagation(this.request.getParameterMap());
                if (httpRequest.getSession(false) == null) {
                    httpRequest.getSession(true);
                }
            }
            super.onBeginRequest();
            Events.instance().raiseEvent("org.jboss.seam.wicket.beforeRequest", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onEndRequest() {
            try {
                super.onEndRequest();
                Events.instance().raiseEvent("org.jboss.seam.wicket.afterRequest", new Object[0]);
            }
            finally {
                if (Contexts.getEventContext() != null && !((SeamWebApplication)this.getApplication()).isDestroyContextsLazily()) {
                    this.destroyContexts();
                }
            }
        }

        private void destroyContexts() {
            try {
                HttpServletRequest httpRequest = ((WebRequest)this.request).getHttpServletRequest();
                Manager.instance().endRequest((Map)new ServletRequestSessionMap(httpRequest));
                ServletLifecycle.endRequest((HttpServletRequest)httpRequest);
            }
            catch (Exception e) {
                Lifecycle.endRequest();
                log.warn((Object)"ended request due to exception", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

