//$Id: JavaHotRedeployable.java,v 1.4 2007/06/20 21:12:46 gavin Exp $
package org.jboss.seam.init;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

import org.jboss.seam.deployment.ComponentScanner;

/**
 * Hot redeployment of Java classes
 *
 * @author Emmanuel Bernard
 */
class JavaHotRedeployable implements RedeployableStrategy
{

   protected File[] paths;
   protected ClassLoader classLoader;

   public JavaHotRedeployable(File directory)
   {
      try
      {
         if (directory.exists())
         {
            URL url = directory.toURL();
            /*File[] jars = directory.listFiles( new FilenameFilter() {
                  public boolean accept(File file, String name) { return name.endsWith(".jar"); }
            } );
            URL[] urls = new URL[jars.length];
            for (int i=0; i<jars.length; i++)
            {
               urls[i] = jars[i].toURL();
            }*/
            URL[] urls = { url };
            classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            paths = new File[] { directory };
         }

      }
      catch (MalformedURLException mue)
      {
         throw new RuntimeException(mue);
      }
   }

   public ClassLoader getClassLoader()
   {
      return classLoader;
   }

   public File[] getPaths()
   {
      return paths;
   }

   public ComponentScanner getScanner()
   {
      //no classloader means we did not find the path
      return classLoader != null ? new ComponentScanner(null, classLoader) : null;
   }

   public boolean isFromHotDeployClassLoader(Class componentClass)
   {
      return componentClass.getClassLoader() == classLoader;
   }
}
