/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.faces.Converter;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

@Converter(forClass=Date.class)
@Name(value="org.jboss.seam.faces.dateConverter")
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
public class DateConverter
extends DateTimeConverter {
    private Log log = Logging.getLog(DateConverter.class);
    private static final String TYPE_DATE = "date";
    private static final String STYLE_SHORT = "short";
    private static final String TWO_DIGIT_YEAR_PATTERN = "yy";
    private static final String FOUR_DIGIT_YEAR_PATTERN = "yyyy";

    public DateConverter() {
        this.setType(TYPE_DATE);
        this.setDateStyle(STYLE_SHORT);
        this.setTimeStyle(STYLE_SHORT);
    }

    @Create
    public void create() {
        DateFormat dateFormat;
        if (TYPE_DATE.equals(this.getType()) && STYLE_SHORT.equals(this.getDateStyle()) && this.getPattern() == null && (dateFormat = DateFormat.getDateInstance(3, this.getLocale())) instanceof SimpleDateFormat) {
            this.setPattern(((SimpleDateFormat)dateFormat).toPattern().replace(TWO_DIGIT_YEAR_PATTERN, FOUR_DIGIT_YEAR_PATTERN));
        }
        this.setTimeZone(this.getTimeZone());
        this.setLocale(this.getLocale());
    }

    public TimeZone getTimeZone() {
        if (Contexts.isApplicationContextActive()) {
            return org.jboss.seam.international.TimeZone.instance();
        }
        return TimeZone.getDefault();
    }

    public Locale getLocale() {
        if (Contexts.isApplicationContextActive()) {
            return org.jboss.seam.international.Locale.instance();
        }
        return super.getLocale();
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Converting string '#0' to date for clientId '#1' using Seam's built-in JSF date converter", value, component.getClientId(context));
        }
        return super.getAsObject(context, component, value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Converting date '#0' to string for clientId '#1' using Seam's built-in JSF date converter", value, component.getClientId(context));
        }
        return super.getAsString(context, component, value);
    }
}

