/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.test;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.jcr.RepositoryFactory;
import org.jboss.seam.jcr.test.BaseDeploymentFactory;
import org.jboss.seam.jcr.test.DefaultBaseDeploymentFactory;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class Utils {
    private static ServiceLoader<BaseDeploymentFactory> deploymentFactoryLoader = ServiceLoader.load(BaseDeploymentFactory.class);

    private static BaseDeploymentFactory getBaseDeploymentFactory() {
        BaseDeploymentFactory baseDeploymentFactory = null;
        Iterator<BaseDeploymentFactory> i$ = deploymentFactoryLoader.iterator();
        while (i$.hasNext()) {
            BaseDeploymentFactory factory;
            baseDeploymentFactory = factory = i$.next();
        }
        if (baseDeploymentFactory == null) {
            baseDeploymentFactory = new DefaultBaseDeploymentFactory();
        }
        return baseDeploymentFactory;
    }

    public static WebArchive baseModeshapeDeployment() {
        return Utils.getBaseDeploymentFactory().baseModeshapeDeployment();
    }

    public static WebArchive baseJackrabbitDeployment() {
        return Utils.getBaseDeploymentFactory().baseJackrabbitDeployment();
    }

    public static RepositoryFactory locateRepositoryFactory() {
        ServiceLoader<RepositoryFactory> rfsl = ServiceLoader.load(RepositoryFactory.class);
        return rfsl.iterator().next();
    }

    public static boolean isModeshape() {
        RepositoryFactory rf = Utils.locateRepositoryFactory();
        return rf.getClass().getCanonicalName().startsWith("org.modeshape");
    }

    public static boolean isJackrabbit() {
        RepositoryFactory rf = Utils.locateRepositoryFactory();
        return rf.getClass().getCanonicalName().startsWith("org.apache.jackrabbit");
    }
}

