/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.test.ocm;

import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.Session;
import junit.framework.Assert;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.jcr.JcrCDIEventListener;
import org.jboss.seam.jcr.annotations.JcrConfiguration;
import org.jboss.seam.jcr.annotations.ocm.JcrNode;
import org.jboss.seam.jcr.ocm.JcrOCMExtension;
import org.jboss.seam.jcr.ocm.NodeConverter;
import org.jboss.seam.jcr.ocm.OCMMapping;
import org.jboss.seam.jcr.ocm.OCMMappingStore;
import org.jboss.seam.jcr.repository.RepositoryResolverImpl;
import org.jboss.seam.jcr.test.ocm.BasicNode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public abstract class OCMExtensionTest {
    @Inject
    JcrOCMExtension extension;
    @Inject
    private Session session;
    @Inject
    NodeConverter nodeConverter;

    public static WebArchive updateArchive(WebArchive archive) {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)archive.addClass(OCMExtensionTest.class)).addClasses(new Class[]{BasicNode.class, OCMMappingStore.class, OCMMapping.class, NodeConverter.class})).addAsServiceProvider(Extension.class, new Class[]{JcrOCMExtension.class})).addPackage(JcrOCMExtension.class.getPackage())).addPackage(RepositoryResolverImpl.class.getPackage())).addPackage(JcrNode.class.getPackage())).addPackage(JcrConfiguration.class.getPackage())).addPackage(JcrCDIEventListener.class.getPackage());
    }

    @Test
    public void testRun() {
        OCMMappingStore ocmMappingStore = this.extension.getOCMMappingStore();
        OCMMapping mapping = ocmMappingStore.findMapping(BasicNode.class);
        Assert.assertNotNull((Object)mapping);
        Assert.assertEquals((int)3, (int)mapping.getFieldsToProperties().size());
        String result = (String)mapping.getFieldsToProperties().get("value");
        Assert.assertEquals((String)"myvalue", (String)result);
        String uuid = (String)mapping.getFieldsToProperties().get("uuid");
        Assert.assertEquals((String)"uuid", (String)uuid);
        String notaproperty = (String)mapping.getFieldsToProperties().get("lordy");
        Assert.assertEquals((String)"notaproperty", (String)notaproperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNodeAndOCM() throws Exception {
        try {
            Node root = this.session.getRootNode();
            Node hello = root.addNode("ocmnode1", "nt:unstructured");
            hello.setProperty("myvalue", "Hello, World!");
            hello.setProperty("notaproperty", "this was saved.");
            Node hello2 = root.getNode("ocmnode1");
            BasicNode bn = (BasicNode)this.nodeConverter.nodeToObject(hello2, BasicNode.class);
            Assert.assertEquals((String)"Hello, World!", (String)bn.getValue());
            Assert.assertEquals((String)"this was saved.", (String)bn.getLordy());
            Node hello3 = root.addNode("ocmnode3", "nt:unstructured");
            this.session.save();
            BasicNode bn3 = new BasicNode();
            bn3.setValue("some random value");
            Node hello3b = root.getNode("ocmnode3");
            this.nodeConverter.objectToNode((Object)bn3, hello3b);
            Assert.assertEquals((String)hello3b.getProperty("myvalue").getString(), (String)bn3.getValue());
        }
        finally {
            this.session.logout();
        }
    }
}

