/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.events;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.jboss.logging.Logger;
import org.jboss.seam.jcr.events.NodeAddedLiteral;
import org.jboss.seam.jcr.events.NodeMovedLiteral;
import org.jboss.seam.jcr.events.NodeRemovedLiteral;
import org.jboss.seam.jcr.events.PersistLiteral;
import org.jboss.seam.jcr.events.PropertyAddedLiteral;
import org.jboss.seam.jcr.events.PropertyChangedLiteral;
import org.jboss.seam.jcr.events.PropertyRemovedLiteral;
import org.jboss.seam.solder.core.Veto;

@Veto
public final class JcrCDIEventListener
implements EventListener {
    private BeanManager beanManager;
    private Logger logger = Logger.getLogger(JcrCDIEventListener.class);

    public JcrCDIEventListener(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public void onEvent(EventIterator events) {
        this.logger.debugf("Event iterator size: %s", (Object)events.getSize());
        while (events.hasNext()) {
            Event event = events.nextEvent();
            this.logger.debugf("About to fire an event of type: %s", (Object)event.getType());
            this.beanManager.fireEvent((Object)event, new Annotation[]{this.getQualifierByEvent(event)});
        }
    }

    Annotation getQualifierByEvent(Event event) {
        Annotation qualifier;
        switch (event.getType()) {
            case 1: {
                qualifier = NodeAddedLiteral.INSTANCE;
                break;
            }
            case 32: {
                qualifier = NodeMovedLiteral.INSTANCE;
                break;
            }
            case 2: {
                qualifier = NodeRemovedLiteral.INSTANCE;
                break;
            }
            case 64: {
                qualifier = PersistLiteral.INSTANCE;
                break;
            }
            case 4: {
                qualifier = PropertyAddedLiteral.INSTANCE;
                break;
            }
            case 16: {
                qualifier = PropertyChangedLiteral.INSTANCE;
                break;
            }
            case 8: {
                qualifier = PropertyRemovedLiteral.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Event type unrecognized: " + event);
            }
        }
        return qualifier;
    }
}

