/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.repository;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.jcr.Session;
import org.jboss.seam.jcr.EventListenerConfig;
import org.jboss.seam.jcr.JcrCDIEventListener;
import org.jboss.seam.jcr.annotations.JcrConfiguration;
import org.jboss.seam.jcr.repository.RepositoryResolver;
import org.jboss.seam.jcr.repository.SeamEventRepositoryImpl;
import org.jboss.seam.solder.logging.Logger;
import org.jboss.seam.solder.reflection.AnnotationInspector;

public class RepositoryResolverImpl
implements RepositoryResolver {
    private final Logger logger = Logger.getLogger(RepositoryResolverImpl.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    @Named(value="jcrRepositoryConfigMap")
    private Instance<Map<String, String>> configParameters;
    @Inject
    private Instance<Credentials> credentialsInstance;
    @Inject
    @Named(value="javax.jcr.Workspace")
    private Instance<String> workspaceInstance;

    @Produces
    public Repository produceRepository(InjectionPoint injectionPoint) throws RepositoryException {
        Map<String, String> parameters;
        Annotation[] qualifiers = this.getQualifiers(injectionPoint);
        Instance qualifiedParams = this.configParameters.select(qualifiers);
        if (qualifiedParams.isUnsatisfied()) {
            JcrConfiguration jcrRepo = (JcrConfiguration)AnnotationInspector.getAnnotation((Annotated)injectionPoint.getAnnotated(), JcrConfiguration.class, (BeanManager)this.beanManager);
            JcrConfiguration.List jcrRepoList = (JcrConfiguration.List)AnnotationInspector.getAnnotation((Annotated)injectionPoint.getAnnotated(), JcrConfiguration.List.class, (BeanManager)this.beanManager);
            parameters = this.buildParameters(jcrRepo, jcrRepoList);
        } else {
            parameters = (Map<String, String>)qualifiedParams.get();
        }
        return this.decorateRepository(this.createPlainRepository(parameters));
    }

    public Map<String, String> buildParameters(JcrConfiguration configuration, JcrConfiguration.List jcrRepoList) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (configuration != null) {
            parameters.put(configuration.name(), configuration.value());
        }
        if (jcrRepoList != null) {
            for (JcrConfiguration conf : jcrRepoList.value()) {
                parameters.put(conf.name(), conf.value());
            }
        }
        return parameters;
    }

    public Session createSessionFromParameters(JcrConfiguration configuration, JcrConfiguration.List jcrRepoList) throws RepositoryException {
        Map<String, String> parameters = this.buildParameters(configuration, jcrRepoList);
        Repository repository = this.decorateRepository(this.createPlainRepository(parameters));
        Credentials c = null;
        String workspaceName = null;
        return repository.login(c, workspaceName);
    }

    @Produces
    public Session produceSession(InjectionPoint injectionPoint) throws RepositoryException {
        Repository repo = this.produceRepository(injectionPoint);
        Annotation[] qualifiers = this.getQualifiers(injectionPoint);
        Credentials c = this.credentialsInstance.isUnsatisfied() ? null : (Credentials)this.credentialsInstance.select(qualifiers).get();
        String workspaceName = this.workspaceInstance.isUnsatisfied() ? null : (String)this.workspaceInstance.select(qualifiers).get();
        return repo.login(c, workspaceName);
    }

    private Annotation[] getQualifiers(InjectionPoint injectionPoint) {
        Annotation[] qualifiers = injectionPoint.getQualifiers().toArray(new Annotation[0]);
        return qualifiers;
    }

    private Repository createPlainRepository(Map<String, String> parameters) throws RepositoryException {
        RepositoryFactory factory;
        Repository repository = null;
        Iterator<RepositoryFactory> i$ = ServiceLoader.load(RepositoryFactory.class).iterator();
        while (i$.hasNext() && (repository = (factory = i$.next()).getRepository(parameters)) == null) {
        }
        return repository;
    }

    private Repository decorateRepository(Repository repository) {
        if (repository == null) {
            return null;
        }
        JcrCDIEventListener eventListener = new JcrCDIEventListener(this.beanManager);
        EventListenerConfig config = EventListenerConfig.DEFAULT;
        return new SeamEventRepositoryImpl(repository, config, eventListener);
    }

    public void cleanSession(@Disposes @Any Session session) {
        try {
            session.save();
            session.logout();
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"Error saving session", (Throwable)e);
        }
    }
}

