/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import javax.enterprise.inject.spi.BeanManager;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.logging.Logger;

public abstract class AbstractMessageListener
implements MessageListener {
    private Logger logger = Logger.getLogger(AbstractMessageListener.class);
    protected BeanManager beanManager;
    protected ClassLoader classLoader;

    protected AbstractMessageListener() {
    }

    protected AbstractMessageListener(BeanManager beanManager, ClassLoader classLoader) {
        this();
        this.beanManager = beanManager;
        this.classLoader = classLoader;
        this.logger.debug((Object)"Creating new AbstractMessageListener.");
    }

    protected void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        this.logger.info((Object)"Received a message");
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            this.handleMessage(message);
        }
        catch (JMSException e) {
            this.logger.warn((Object)"A JMS Exception occurred during processing.", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
    }

    protected abstract void handleMessage(Message var1) throws JMSException;
}

