/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.inject;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.seam.jms.annotations.JmsDefault;
import org.jboss.solder.logging.Logger;

@ApplicationScoped
public class JmsConnectionFactoryProducer {
    private String connectionFactoryJNDILocation = "/ConnectionFactory";
    private Logger logger = Logger.getLogger(JmsConnectionFactoryProducer.class);
    @Inject
    Context context;

    @Produces
    @ApplicationScoped
    @JmsDefault(value="connectionFactory")
    public ConnectionFactory produceConnectionFactory() {
        try {
            return (ConnectionFactory)this.context.lookup(this.connectionFactoryJNDILocation);
        }
        catch (NamingException e) {
            this.logger.info((Object)("Unable to look up " + this.connectionFactoryJNDILocation + " in JNDI"), (Throwable)e);
            return null;
        }
    }
}

