/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.example.statuswatcher.session;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.event.ValueChangeEvent;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.jboss.logging.Logger;
import org.jboss.seam.jms.DurableMessageManager;
import org.jboss.seam.jms.example.statuswatcher.model.Status;
import org.jboss.seam.jms.example.statuswatcher.qualifiers.StatusTopic;
import org.jboss.seam.jms.example.statuswatcher.session.ReceivingClientListener;
import org.jboss.seam.jms.example.statuswatcher.session.StatusManager;

@SessionScoped
@Named
public class ReceivingClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int uniqueId = 1;
    @Inject
    private Logger log;
    @Inject
    private DurableMessageManager dmm;
    @Inject
    private StatusManager manager;
    @Inject
    private BeanManager beanManager;
    private LinkedList<Status> receivedStatuses;
    private boolean followAll = false;
    private String clientSubscription;
    private String clientId;
    @Inject
    @StatusTopic
    private Topic statusTopic;

    @PostConstruct
    public void initialize() {
        this.receivedStatuses = new LinkedList();
        this.clientSubscription = "subscription" + ++uniqueId;
        this.clientId = "client" + uniqueId;
    }

    @PreDestroy
    public void cleanup() throws Exception {
        this.dmm.unsubscribe(this.clientId);
    }

    public void changeFollowing(ValueChangeEvent e) throws Exception {
        this.followAll = (Boolean)e.getNewValue();
        if (this.followAll) {
            this.dmm.login(this.clientId);
            ReceivingClientListener rcl = new ReceivingClientListener(this.beanManager, Thread.currentThread().getContextClassLoader(), this);
            this.dmm.createDurableSubscriber(this.statusTopic, this.clientSubscription, new MessageListener[]{rcl});
        } else {
            this.dmm.unsubscribe(this.clientId);
        }
    }

    public void history() {
        this.receivedStatuses = new LinkedList(this.manager.getAllStatuses());
    }

    public List<Status> getReceivedStatuses() throws Exception {
        return this.receivedStatuses;
    }

    public void setReceivedStatuses(LinkedList<Status> receivedStatuses) {
        this.receivedStatuses = receivedStatuses;
    }

    public boolean isFollowAll() {
        return this.followAll;
    }

    public void setFollowAll(boolean followAll) {
        this.followAll = followAll;
    }

    public void notify(Status status) {
        this.log.info((Object)"Received status update");
        this.receivedStatuses.offerFirst(status);
    }
}

