/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.example.statuswatcher.session;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.jboss.seam.jms.example.statuswatcher.session.ReceivingClient;
import org.jboss.seam.solder.logging.Logger;

public class ReceivingClientListener
implements MessageListener {
    private ReceivingClient client;
    private Logger logger;

    public ReceivingClientListener(ReceivingClient client) {
        this.client = client;
        this.logger = Logger.getLogger(ReceivingClientListener.class);
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage om = (ObjectMessage)message;
                Serializable obj = om.getObject();
                Integer id = (Integer)obj;
                this.client.notify(id);
            } else {
                this.logger.infof("Received an invalid message %s", (Object)message);
            }
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Unable to handle JMS Message: ", (Throwable)e);
        }
    }
}

