/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.example.statuswatcher.messagedriven;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.jboss.seam.jms.example.statuswatcher.model.Status;
import org.jboss.seam.jms.example.statuswatcher.session.StatusManager;
import org.jboss.solder.logging.Logger;

@MessageDriven(name="OrderProcessor", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="/jms/updateStatusQueue")}, mappedName="jms/updateStatusQueue")
public class DistributorMDB
implements MessageListener {
    @Inject
    private Logger log;
    @EJB
    private StatusManager manager;
    @Resource(mappedName="/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource(mappedName="/jms/statusInfoTopic")
    private Topic statusTopic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Connection connection = null;
        try {
            ObjectMessage om = (ObjectMessage)message;
            Status status = (Status)om.getObject();
            Status result = this.manager.addStatusMessage(status);
            connection = this.connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            TopicPublisher publisher = ((TopicSession)session).createPublisher(this.statusTopic);
            ObjectMessage update = session.createObjectMessage((Serializable)Integer.valueOf(result.getId()));
            publisher.send((Message)update);
        }
        catch (JMSException e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    this.log.warn((Object)"Closing of a connection failed");
                }
            }
        }
    }
}

