/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.example.statuswatcher.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class Status
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long MS_PER_SECOND = 1000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_DAY = 86400000L;
    private static final SimpleDateFormat df = new SimpleDateFormat("d MMM");
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private int id;
    private String username;
    private String statusMessage;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datetime;

    public Status() {
        this.statusMessage = "Enter a new status message...";
    }

    public Status(String username, String message) {
        this.username = username;
        this.statusMessage = message;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public int getId() {
        return this.id;
    }

    public void setsId(int id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public void setDatetime(Date datetime) {
        this.datetime = datetime;
    }

    public String getFriendlyDate() {
        if (this.getDatetime() == null) {
            return "unknown";
        }
        Date now = new Date();
        long age = now.getTime() - this.getDatetime().getTime();
        long days = (long)Math.floor(age / 86400000L);
        long hours = (long)Math.floor((age -= days * 86400000L) / 3600000L);
        long minutes = (long)Math.floor((age -= hours * 3600000L) / 60000L);
        if (days < 7L) {
            StringBuilder sb = new StringBuilder();
            if (days > 0L) {
                sb.append(days);
                sb.append(days > 1L ? " days " : " day ");
            }
            if (hours > 0L) {
                sb.append(hours);
                sb.append(hours > 1L ? " hrs " : " hr ");
            }
            if (minutes > 0L) {
                sb.append(minutes);
                sb.append(minutes > 1L ? " minutes " : " minute ");
            }
            if (hours == 0L && minutes == 0L) {
                sb.append("just now");
            } else {
                sb.append("ago");
            }
            return sb.toString();
        }
        return df.format(this.getDatetime());
    }

    public String toString() {
        return "User: " + this.username + ", Time: " + this.getFriendlyDate() + ", Status: " + this.statusMessage;
    }
}

