/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.example.statuswatcher.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.jboss.seam.jms.TopicBuilder;
import org.jboss.seam.jms.example.statuswatcher.model.Status;
import org.jboss.seam.jms.example.statuswatcher.session.ReceivingClientListener;
import org.jboss.seam.jms.example.statuswatcher.session.StatusManager;
import org.jboss.solder.logging.Logger;

@SessionScoped
@Named(value="receivingClient")
public class ReceivingClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Logger log;
    @Inject
    private StatusManager manager;
    private LinkedList<Status> receivedStatuses;
    private List<Integer> pendingStatuses;
    private boolean followAll = false;
    @Inject
    TopicBuilder topicBuilder;
    @EJB
    StatusManager statusManager;
    @Resource(mappedName="java:/jms/statusInfoTopic")
    Topic statusInfoTopic;
    @Resource(mappedName="java:/ConnectionFactory")
    ConnectionFactory connectionFactory;

    @PostConstruct
    public void initialize() {
        this.log.debug((Object)"Creating new ReceivingClient.");
        this.pendingStatuses = new ArrayList();
        this.receivedStatuses = new LinkedList();
        this.topicBuilder.sessionMode(1).connectionFactory(this.connectionFactory).destination(this.statusInfoTopic).listen((MessageListener)new ReceivingClientListener(this));
    }

    public String receive() {
        for (Integer statusId : this.pendingStatuses) {
            Status status = this.statusManager.find(statusId.intValue());
            this.log.debug((Object)"Received status update");
            this.receivedStatuses.offerFirst(status);
        }
        this.pendingStatuses.clear();
        return "/watchstatus.xhtml";
    }

    public String send() {
        return "/sendstatus.xhtml";
    }

    public void history() {
        this.receivedStatuses = new LinkedList(this.manager.getAllStatuses());
    }

    public List<Status> getReceivedStatuses() throws Exception {
        return this.receivedStatuses;
    }

    public void setReceivedStatuses(LinkedList<Status> receivedStatuses) {
        this.receivedStatuses = receivedStatuses;
    }

    public boolean isFollowAll() {
        return this.followAll;
    }

    public void setFollowAll(boolean followAll) {
        this.followAll = followAll;
    }

    public void notify(Integer statusId) {
        this.pendingStatuses.add(statusId);
    }
}

