/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.jboss.seam.jms.DurableMessageManager;
import org.jboss.seam.jms.MessageManagerImpl;
import org.jboss.seam.jms.annotations.Durable;
import org.jboss.seam.jms.annotations.JmsDefault;
import org.jboss.solder.logging.Logger;

@Dependent
@Durable
public class DurableMessageManagerImpl
extends MessageManagerImpl
implements DurableMessageManager {
    private Logger logger = Logger.getLogger(DurableMessageManagerImpl.class);
    @Inject
    @JmsDefault(value="connectionFactory")
    ConnectionFactory connectionFactory;
    private Connection connection;

    @PostConstruct
    public void init() {
        try {
            this.connection = this.connectionFactory.createConnection();
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Unable to create connection.");
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.warn((Object)"Unable to create connection.");
            }
        }
    }

    public void login(String clientId) {
        try {
            this.connection.setClientID(clientId);
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Unable to create connection.");
        }
    }

    public TopicSubscriber createDurableSubscriber(String topic, String id, MessageListener ... listeners) {
        Topic t = (Topic)super.lookupDestination(topic);
        return this.createDurableSubscriber(t, id, listeners);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String id, MessageListener ... listeners) {
        TopicSubscriber ts;
        try {
            ts = this.session.createDurableSubscriber(topic, id);
            if (ts != null && listeners != null && listeners.length > 0) {
                for (MessageListener listener : listeners) {
                    try {
                        ts.setMessageListener(listener);
                    }
                    catch (JMSException e) {
                        this.logger.warn((Object)("Unable to map listener " + listener + " to subscriber " + ts), (Throwable)e);
                    }
                }
            }
        }
        catch (JMSException ex) {
            throw new IllegalArgumentException("Unable to create subscriber on topic " + topic + " for id " + id, ex);
        }
        return ts;
    }

    public void unsubscribe(String id) {
        try {
            this.session.unsubscribe(id);
        }
        catch (JMSException e) {
            this.logger.warn((Object)("Unable to unsubscribe for id: " + id), (Throwable)e);
        }
    }
}

